#
# some usefull aliases
#
# WARNING:
#   bash aliases are not inherited to subshells,
#   therefore this aliases are only available at login shells.
#   Therefore replaced alias by exported shell functions.
#   Otherwise, if aliases should be available everywhere,
#   add following line to /etc/bash.bashrc.local:
#   source /etc/profile.d/dass-it.sh

alias_set_old()
{
  name=$1
  shift
  alias $name >/dev/null 2>&1 || alias $name="$@"
}

alias_set()
{
  name=$1
  shift
  cmd=$1
  shift
  if ! type $name >/dev/null 2>&1; then
    if [ "$BASH" ] && [ "$BASH" != "/bin/sh" ]; then
      eval "$name() {
        $cmd \"\$@\"
      }
      export -f $name"
    else
      alias_set_old "$name" "$cmd" "$@"
    fi
  fi
}


alias_set l "ls -la"
alias_set .. "cd .."
alias_set ... "cd ../.."
alias_set lsst 'find -type f -printf "%T@  %T+   %P\n" | sort -n'
alias_set rpm-disturl 'rpm -q --qf "%{DISTURL}\n"'
alias_set rpm-sortsize 'rpm -qa --qf "%{SIZE} %{NAME}\n" | sort -n'
alias_set rscp 'rsync -av --progress --compress'

setproxy()
{
    PAR="$1"
    if [ -z "$PAR" ]; then
        unset http_proxy
        unset https_proxy
        return
    fi

    if [[ "$PAR" == http* ]]; then
        PROXY="$PAR"
    else
        PROXY="http://$PAR"
    fi
    export http_proxy="$PROXY"
    export https_proxy="$PROXY"
    echo $http_proxy
}
if [ "$BASH" ] && [ "$BASH" != "/bin/sh" ]; then
    export -f setproxy
fi
