#!/bin/sh
name=dassldapsync
version=$(awk '/^Version:/ { print $2 }' $name.spec)
debversion=$(head -1 debian/changelog | sed 's/.*[(]\(.*\)[)].*/\1/')
debtar=${name}_$version.tar.gz
rm -f build-stamp
rm -rf debian/$name debian/$name.debhelper.log debian/$name.substvars

(cd ..;tar czf /tmp/$debtar --exclude .svn $name)
filesize=$(ls -l /tmp/$debtar | awk '{ print $5 }')
md5sum=$(md5sum /tmp/$debtar | awk '{ print $1}')
sha1sum=$(sha1sum /tmp/$debtar  | awk '{ print $1}')
sha256sum=$(sha256sum /tmp/$debtar  | awk '{ print $1}')
cat >/tmp/${name}.dsc << EOF
Format: 1.0
Source: $name
Binary: $name
Architecture: all
Version: $debversion
Maintainer: Sebastian Lederer <slederer@dass-it.de>
Standards-Version: 3.6.1
Build-Depends: debhelper (>= 4.0.0), python (>= 2.6)
Package-List: 
 $name deb contrib/admin optional
Checksums-Sha1: 
 $sha1sum $filesize $debtar
Checksums-Sha256: 
 $sha256sum $filesize $debtar
Files: 
 $md5sum $filesize $debtar
EOF
cp $name.spec /tmp
ls -l /tmp/$name*
