# -*- coding: utf-8 -*-
"""Classes and functions for configuration file handling
"""

import sys 
import re

RESOURCE_TYPES = ('dird', 'console', 'filed', 'stored')

#'dird', 'console', 'filed' or 'stored'
class Config(Object):
    """Class for bacula configuration access"""
    
    def __init__(self, resource_type, filename=""):
        self.resource_type = resource_type
        self.filename = filename

    def read(self):
        pass
    
    def write(self):
        pass
    
class DirdConfig(Config):
    pass

class ConsoleConfig(Config):
    pass

class FiledConfig(Config):
    pass

class StoredConfig(Config):
    pass

class baculaRessource:
    """ generic bacula support Type      
    """
    name = None;
    resourceDirectives = {}
    mandatoryDirectives = {} # which directives must be configured?
     
    def printdict(self,mydict,indent=''):
        ressource = 'unknown'
        #indent += '  '        
        if type(mydict) == dict :   
            if '_ressourceName' in mydict:
                v = mydict['_ressourceName']
                ressource =  v
                print indent + v + " {"
                indent += '  ' 
            
            for p,v in mydict.iteritems():
                #print "v: " ,  v
                if type(v) == str:                          # leaf
                    if p == '_ressourceName':
                        continue
                    print indent + p + " = " +  v
                    
                elif type(v) == dict : 
                    #print indent + p + " {" 
                    #ressource = p
                    self.printdict(v,indent)
                    
                elif type(v) ==  list :
                    #ressource = "list"
                    for i in v:
                        print indent + p + " = " + i
                        
        if type(mydict) == list :
            for i in mydict:
          
                if i == '_ressourceName':
                    Name = i['Name']
                    print indent + Name
                    self.printdict(i,indent)
                else:                                    # leaf
                    print indent + i

        if type(mydict) == str:
            print indent + "direct" + mydict
        indent = indent[:-2]    
        print indent + "} # " + ressource
    

    
    def __init__(self, name, resourceDirectives):
        #resourceDirectives = {'name':'bacula-dir', 'Test':'test'}  # the configured directives
        self.name = name
        self.resourceDirectives =  resourceDirectives

        
        
    def __str__(self):                      # overload print function
        self.printdict(self.resourceDirectives,"")
        s  = ''
        #s = self.name + ' {\n'
        #for directive,value in self.resourceDirectives.iteritems() :
        #    s += ' ' +directive + ' = ' + value + '\n'
        #s += '}\n'
        return s
    

mybaculaRessource = baculaRessource("myRessource",{'name':'bacula-dir', 'Test':'test'})


print  mybaculaRessource

multiRes = set(['Run','File','Ip']) # entries, which can be multiple times in a ressource

f = open("bacula-dir.conf",'r')

#p = re.compile('\s*([\S ]+)\s*=\s*(\S+)\s*') # xxx = xxx matchen
p = re.compile('\s*([\S]+)\s*=\s*(.*)$') # xxx = xxx matchen
#openbrace = re.compile('\s*([\S ]+)\s*{.*')    # match xxx {
openbrace = re.compile('\s*([\S ]+)=?\s+{.*')    # match xxx {

closebrace = re.compile('.*}.*')               # match }
comment = re.compile('^\s*#.*')

#myRes = {} ; # RessourcenDict erzeugen

dirRes=[] # Liste der Director Ressourcen



braceLevel = 0;
#print p
tmpRes = {}
treeindex=range(10)

for line in f:
        #print braceLevel,line
        commentline = comment.match(line)
        if commentline:
            #print "found commentline: " + commentline.group(0)
            continue
        #print braceLevel
        openbraceline = openbrace.match(line)
        closebraceline = closebrace.match(line)
        m = p.match(line)
        
        if openbraceline:
            #print "found openbraceline: " + openbraceline.group(0)
            braceLevel += 1
            if braceLevel == 1: # First level
                fatherRes = {}
                fatherRes['_ressourceName'] = openbraceline.group(1)
                dirRes.append(fatherRes)
                treeindex[braceLevel] = fatherRes
            else:
                sonRes = {}; #
                sonRes['_ressourceName'] = openbraceline.group(1)
                fatherRes[openbraceline.group(1)] = sonRes;
                #print "creating new sonres for", openbraceline.group(1),"in" , fatherRes['_ressourceName']
                #treeindex[braceLevel]=fatherRes;
                #tmpRes = fatherRes;
                fatherRes = sonRes;
                treeindex[braceLevel]=fatherRes;
        elif closebraceline:
            braceLevel -= 1
            fatherRes = treeindex[braceLevel]
            
        elif m:
                if m.group(1) in multiRes:                 # create a new list for multiple Entries
                    try:
                        fatherRes[m.group(1)].append(m.group(2))
                    except:
                    #if  ( fatherRes[m.group(1)] != None):           # add a listentry if not already there
                        multilist = []
    asd                    multilist.append(m.group(2))
                        fatherRes[m.group(1)] = multilist
                else:
                    try:
                        if fatherRes[m.group(1)]:
                            print "Warning: overwriting "+ m.group(1) 
                    except:
                        fatherRes[m.group(1)] = m.group(2)
                #print braceLevel,m.group(2)


myNewResDict={}

#mybaculaRessource = baculaRessource("myRessource",{'name':'bacula-dir', 'Test':'test'})
#print  mybaculaRessource


for tmpdict in dirRes:
    #print tmpdict['_ressourceName']
    
    try:
        myNewResDict[tmpdict['_ressourceName']].append(tmpdict)
    except:
        myNewResDict[tmpdict['_ressourceName']]=[]
        myNewResDict[tmpdict['_ressourceName']].append(tmpdict)
    myBacRes = baculaRessource(tmpdict['_ressourceName'],tmpdict)
    print myBacRes


