/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;

public class SelectItemsIterator
implements Iterator {
    private final Iterator _childs;
    private Iterator _nestedItems;
    private Object _nextItem;
    private String _collectionLabel;
    private UISelectItems _currentUISelectItems;

    public SelectItemsIterator(UIComponent selectItemsParent) {
        this._childs = selectItemsParent.getChildren().iterator();
    }

    public boolean hasNext() {
        if (this._nextItem != null) {
            return true;
        }
        if (this._nestedItems != null) {
            if (this._nestedItems.hasNext()) {
                return true;
            }
            this._nestedItems = null;
        }
        if (this._childs.hasNext()) {
            UIComponent child = (UIComponent)this._childs.next();
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object item = uiSelectItem.getValue();
                if (item == null) {
                    Object itemValue = ((UISelectItem)child).getItemValue();
                    String label = ((UISelectItem)child).getItemLabel();
                    String description = ((UISelectItem)child).getItemDescription();
                    boolean disabled = ((UISelectItem)child).isItemDisabled();
                    if (label == null) {
                        label = itemValue.toString();
                    }
                    item = new SelectItem(itemValue, label, description, disabled);
                } else if (!(item instanceof SelectItem)) {
                    ValueBinding binding = ((UISelectItem)child).getValueBinding("value");
                    throw new IllegalArgumentException("Value binding '" + (binding == null ? null : binding.getExpressionString()) + "' of UISelectItem : " + RendererUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                }
                this._nextItem = item;
                return true;
            }
            if (child instanceof UISelectItems) {
                this._currentUISelectItems = (UISelectItems)child;
                Object value = this._currentUISelectItems.getValue();
                if (value instanceof SelectItem) {
                    this._nextItem = value;
                    return true;
                }
                if (value instanceof SelectItem[]) {
                    this._nestedItems = Arrays.asList((SelectItem[])value).iterator();
                    this._collectionLabel = "Array";
                    return this.hasNext();
                }
                if (value instanceof Collection) {
                    this._nestedItems = ((Collection)value).iterator();
                    this._collectionLabel = "Collection";
                    return this.hasNext();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
                    Iterator it = map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        items.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                    }
                    this._nestedItems = items.iterator();
                    this._collectionLabel = "Map";
                    return this.hasNext();
                }
                ValueBinding binding = this._currentUISelectItems.getValueBinding("value");
                throw new IllegalArgumentException("Value binding '" + (binding == null ? null : binding.getExpressionString()) + "'of UISelectItems with component-path " + RendererUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem, SelectItem[], Collection or Map but of type : " + (value == null ? null : value.getClass().getName()));
            }
        }
        return false;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this._nextItem != null) {
            Object value = this._nextItem;
            this._nextItem = null;
            return value;
        }
        if (this._nestedItems != null) {
            Object item = this._nestedItems.next();
            if (!(item instanceof SelectItem)) {
                ValueBinding binding = this._currentUISelectItems.getValueBinding("value");
                throw new IllegalArgumentException(this._collectionLabel + " referenced by UISelectItems with binding '" + binding.getExpressionString() + "' and Component-Path : " + RendererUtils.getPathToComponent((UIComponent)this._currentUISelectItems) + " does not contain Objects of type SelectItem");
            }
            return item;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

