/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.STATE_SAVING_METHOD";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    private Boolean _savingStateInClient = null;

    public abstract SerializedView saveSerializedView(FacesContext var1);

    protected abstract Object getTreeStructureToSave(FacesContext var1);

    protected abstract Object getComponentStateToSave(FacesContext var1);

    public abstract void writeState(FacesContext var1, SerializedView var2) throws IOException;

    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    protected abstract UIViewRoot restoreTreeStructure(FacesContext var1, String var2, String var3);

    protected abstract void restoreComponentState(FacesContext var1, UIViewRoot var2, String var3);

    public boolean isSavingStateInClient(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._savingStateInClient != null) {
            return this._savingStateInClient;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("No state saving method defined, assuming default server state saving");
        } else if (stateSavingMethod.equals(STATE_SAVING_METHOD_CLIENT)) {
            this._savingStateInClient = Boolean.TRUE;
        } else if (stateSavingMethod.equals(STATE_SAVING_METHOD_SERVER)) {
            this._savingStateInClient = Boolean.FALSE;
        } else {
            this._savingStateInClient = Boolean.FALSE;
            context.getExternalContext().log("Illegal state saving method '" + stateSavingMethod + "', default server state saving will be used");
        }
        return this._savingStateInClient;
    }

    public class SerializedView {
        private Object _structure;
        private Object _state;

        public SerializedView(Object structure, Object state) {
            this._structure = structure;
            this._state = state;
        }

        public Object getStructure() {
            return this._structure;
        }

        public Object getState() {
            return this._state;
        }
    }
}

