/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.env.SpringWebFlowInstantiationServlet;
import com.icesoft.faces.webapp.http.core.FlowExecutionHandler;
import com.icesoft.faces.webapp.http.core.FlowExecutionHandlerFactory;
import com.icesoft.faces.webapp.http.core.FlowExecutorUtil;
import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.executor.FlowExecutionResult;

public class SwfLifecycleExecutor
extends LifecycleExecutor {
    private org.springframework.webflow.context.ExternalContext selectedExternalContext = null;
    private String flowExecutionKey = null;
    private String flowId = null;
    private boolean isServletContext = true;
    private HttpServletRequest servletRequest = null;
    private HttpServletResponse servletResponse = null;
    private PortletRequest portletRequest = null;
    private PortletResponse portletResponse = null;
    private FlowExecutorUtil flowExecutorUtil = null;

    public void apply(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object context = externalContext.getContext();
        if (context instanceof ServletContext) {
            this.setupServletContext(externalContext);
        } else {
            this.setupPortletContext(externalContext);
        }
        this.flowExecutorUtil = new FlowExecutorUtil(SpringWebFlowInstantiationServlet.getFlowExecutor(), this.selectedExternalContext);
        FlowExecutionResult result = null;
        try {
            result = null != this.flowExecutionKey ? this.resumeExecution(this.flowExecutionKey) : this.launchExecution();
        }
        catch (NoSuchFlowDefinitionException e) {
            this.getJsfLifecycleExecutor(facesContext);
        }
        FlowExecutionHandler flowExecutionHandler = FlowExecutionHandlerFactory.getInstance(externalContext, result, this.selectedExternalContext, facesContext);
        try {
            flowExecutionHandler.handleFlowExecutionResult();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected void setupServletContext(ExternalContext externalContext) {
        this.isServletContext = true;
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        this.servletRequest = (HttpServletRequest)externalContext.getRequest();
        this.servletResponse = (HttpServletResponse)externalContext.getResponse();
        this.flowExecutionKey = this.servletRequest.getParameter("org.springframework.webflow.FlowExecutionKey");
        if (this.flowExecutionKey == null) {
            this.flowExecutionKey = this.servletRequest.getParameter("execution");
        }
        this.flowId = this.firstSegment(this.servletRequest.getPathInfo());
        this.selectedExternalContext = new ServletExternalContext(servletContext, this.servletRequest, this.servletResponse);
        ((ServletExternalContext)this.selectedExternalContext).setAjaxRequest(true);
    }

    public String firstSegment(String path) {
        String path1 = path.substring(1);
        int end = path1.indexOf("/");
        if (-1 == end) {
            end = path1.length();
        }
        path1 = path1.substring(0, end);
        return path1;
    }

    protected void setupPortletContext(ExternalContext externalContext) {
        this.isServletContext = false;
        PortletContext portletContext = (PortletContext)externalContext.getContext();
        this.portletRequest = (PortletRequest)externalContext.getRequest();
        this.portletResponse = (PortletResponse)externalContext.getResponse();
        String[] flowExecutionKeyArr = null;
        flowExecutionKeyArr = (String[])externalContext.getRequestParameterValuesMap().get("org.springframework.webflow.FlowExecutionKey");
        this.flowExecutionKey = null != flowExecutionKeyArr ? flowExecutionKeyArr[0] : null;
        this.flowId = (String)this.portletRequest.getAttribute("org.springframework.webflow.FlowId");
        this.selectedExternalContext = new PortletExternalContext(portletContext, this.portletRequest, this.portletResponse);
    }

    public FlowExecutionResult resumeExecution(String flowExecutionKey) {
        return this.flowExecutorUtil.resumeExecution(flowExecutionKey);
    }

    public FlowExecutionResult launchExecution() {
        MutableAttributeMap input = this.setupInputMap();
        return this.flowExecutorUtil.launchExecution(input, this.flowId);
    }

    public MutableAttributeMap setupInputMap() {
        MutableAttributeMap input = null;
        input = this.isServletContext ? this.flowExecutorUtil.defaultFlowExecutionInputMap(this.servletRequest) : this.flowExecutorUtil.defaultFlowExecutionInputMapPortlet(this.portletRequest);
        return input;
    }
}

