/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.resolver;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.xml.sax.InputSource;

public class WarFileBasedURIResolver
extends DefaultURIResolver {
    protected static final Log log = LogFactory.getLog(WarFileBasedURIResolver.class);
    private ClassLoader classLoader;

    public WarFileBasedURIResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        if (this.isAbsolute(schemaLocation)) {
            return super.resolveEntity(targetNamespace, schemaLocation, baseUri);
        }
        if ((baseUri == null || "".equals(baseUri)) && schemaLocation.startsWith("..")) {
            throw new RuntimeException("Unsupported schema location " + schemaLocation);
        }
        URI lastImportLocation = URI.create(baseUri).resolve(schemaLocation);
        String searchingStr = lastImportLocation.toString();
        return new InputSource(this.classLoader.getResourceAsStream(searchingStr));
    }
}

