/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.OnDemandRenderer;
import com.icesoft.faces.async.render.RenderManager;

public class SessionRenderer {
    public static final String ALL_SESSIONS = "SessionRenderer.ALL_SESSIONS";

    public static void addCurrentSession(String groupName) throws IllegalStateException {
        RenderManager.getInstance().getOnDemandRenderer(groupName).addCurrentSession();
    }

    public static void removeCurrentSession(String groupName) {
        OnDemandRenderer renderer = SessionRenderer.getRenderer(groupName);
        if (renderer != null) {
            renderer.removeCurrentSession();
            SessionRenderer.removeRendererIfEmpty(renderer);
        }
    }

    public static void render(String groupName) {
        OnDemandRenderer renderer = SessionRenderer.getRenderer(groupName);
        if (renderer != null) {
            renderer.requestRender();
            SessionRenderer.removeRendererIfEmpty(renderer);
        }
    }

    private static OnDemandRenderer getRenderer(String groupName) {
        return (OnDemandRenderer)RenderManager.getInstance().getRenderer(groupName);
    }

    private static void removeRendererIfEmpty(OnDemandRenderer renderer) {
        if (renderer.isEmpty()) {
            RenderManager.getInstance().removeRenderer(renderer);
        }
    }
}

