# 
# Copyright  (c)  2004-2010  dass IT GmbH, Koeln, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# $Id: dasscm.spec 933 2010-12-04 11:32:10Z joergs $

Name:           dasscm
URL:            https://trac.dass-it.de/pub/
License:        GPL
Group:          Development/Tools/Version Control
Autoreqprov:    on
Summary:        Dass Configuration Management
Version:        1.2
Release:        0
Requires:       subversion perl
#               perl-TermReadKey: 
#                   replaced ReadMode('noecho') by `stty -echo` 
#                   to reduce dependencies
Source:         %{name}_%{version}.orig.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch
%if 0%{?suse_version}
BuildRequires:  gzip pam-modules tar
%endif

# Subversion should be installed during build 
# to have the directory /etc/subversion/ available.
# Unfortunally, it isn't included in all distributions,
# therefore we added some checks
#%if 0%{?suse_version} > 1100
#BuildRequires:  subversion
#%endif
 

%description
dasscm is a tool for handling configuration files with subversion

Authors:
--------
       Joerg Steffens

%prep
%setup -c



%build


%install
mkdir -p $RPM_BUILD_ROOT/usr/bin/
install -m 755 usr/bin/dasscm $RPM_BUILD_ROOT/usr/bin/
install -m 755 usr/bin/dasscm_remote_update.sh $RPM_BUILD_ROOT/usr/bin/
mkdir -p $RPM_BUILD_ROOT/var/lib/dasscm/
mkdir -p $RPM_BUILD_ROOT/var/lib/dasscm/plugin-results/

mkdir -p $RPM_BUILD_ROOT/etc/
install -m 640 etc/dasscm.conf $RPM_BUILD_ROOT/etc/
mkdir -p $RPM_BUILD_ROOT/etc/profile.d/
install -m 644 etc/profile.d/dasscm.sh $RPM_BUILD_ROOT/etc/profile.d/

%if %(test -d /etc/bash_completion.d/ && echo 1 || echo 0)
    %define use_bash_completion 1
    mkdir -p $RPM_BUILD_ROOT/etc/bash_completion.d/
    install -m 644 etc/bash_completion.d/bash_completion_dasscm.sh $RPM_BUILD_ROOT/etc/bash_completion.d/dasscm.sh
%endif
%if %(test -d /etc/nagios/nrpe.d/ && echo 1 || echo 0)
    %define use_nagios_nrpe_d 1
    mkdir -p $RPM_BUILD_ROOT/etc/nagios/nrpe.d/
    install -m 644 etc/nagios/nrpe.d/nrpe-dasscm.cfg $RPM_BUILD_ROOT/etc/nagios/nrpe.d/dasscm.cfg
%endif
# /etc/sudoers.d/ is still uncommon, but very useful,
# therefore it is always created
mkdir -p $RPM_BUILD_ROOT/etc/sudoers.d/
install -m 440 etc/sudoers.d/nagios_dasscm_check $RPM_BUILD_ROOT/etc/sudoers.d/



%clean
[ "$RPM_BUILD_ROOT" != "/" ] &&  rm -rf $RPM_BUILD_ROOT

# TODO: group dasscm: 4199
#       without existing group, %attr(640,root,4199)  falls back to root
#       groupadd -g 4199 dasscm

%files
%defattr(-,root,root)
%dir /var/lib/dasscm/
%dir /var/lib/dasscm/plugin-results/
/usr/bin/dasscm
/usr/bin/dasscm_remote_update.sh
%doc Changes doc/* subversion-servers.dass-it

%config(noreplace)  %attr(640,root,root) /etc/dasscm.conf
                    /etc/profile.d/dasscm.sh
%if 0%{?use_bash_completion}
%config(noreplace)  /etc/bash_completion.d/dasscm.sh
%else
%doc                etc/bash_completion.d/bash_completion_dasscm.sh
%endif

%if 0%{?use_nagios_nrpe_d}
%config(noreplace)  /etc/nagios/nrpe.d/dasscm.cfg
%else
%doc                etc/nagios/nrpe.d/nrpe-dasscm.cfg
%endif

# /etc/sudoers.d/ should not belong to dasscm,
# but is does currently not exist on most distributions
%dir /etc/sudoers.d/
# sudo requires permissions 440 and config files without any "."
%attr(440,root,root) %config(noreplace) /etc/sudoers.d/nagios_dasscm_check
