#!/bin/bash

set -o errexit -o nounset

DEST="${1:-}"

if ! [ -d "$DEST" ]; then
    echo "FAILED: no directory given."
    exit
fi

# adapt repository sources
for i in `find $DEST -name "*.repo" -a ! -name "vermkv-*.repo"`; do
    basename=`basename $i`
    dirname=`dirname $i`
    echo "creating $dirname/vermkv-$basename"
    sed "s|http://|http://install.vermkv/freigabe/|" $i > $dirname/vermkv-$basename 
done
