#!/bin/bash

set -o errexit -o nounset

CONFIG=${1:-/etc/mirror-urls.conf} 

# default value, may be overwritten by CONFIG
DEST="/cds/linux/mirror/"

if ! [ -r "$CONFIG" ]; then
  echo "failed to read config file $CONFIG."
  exit 1
fi
source $CONFIG

FAILED=""
SUCCESS=""

cd $DEST

for url in $PROJECTS; do
    printf "$url:\n"
    protocol=`sed -r "s|^([a-zA-Z]+)://.*|\1|" <<< $url`
    host=`sed -r "s|^$protocol://([^/]+)/.*|\1|" <<< $url`
    path=`sed -r "s|$protocol://$host||" <<< $url`
    mkdir -p $host/$path
    DESTDIR=$DEST/$host/$path
    #set -x
    if ! lftp -c "open -e \"mirror --verbose=1 --parallel=20 --continue --delete $path/. ${DESTDIR}\" ${protocol}://${host}"; then
        set +x
        printf "    failed\n"
        FAILED="$FAILED $url"
    else
        set +x
        if [ "${POST_SCRIPT:-}" ]; then
            $POST_SCRIPT ${DESTDIR}
        fi
        printf "    ${DESTDIR}\n"
        SUCCESS="$SUCCESS $url"
    fi
    printf "\n"
done

if [ "${REPORT_SCRIPT:-}" ]; then
    $REPORT_SCRIPT mirror-urls "$SUCCESS" "$FAILED"
fi
