#!/bin/bash

# rpm -qa --nodigest --nosignature --qf "%{NAME}-%{VERSION}-%{RELEASE} %{SUMMARY}\n" gpg-pubkey*
# 
# rpm -q gpg-pubkey-88efc20d-49510a33 --qf "%{DESCRIPTION}" | gpg --with-fingerprint

KEY="$1"

KEYS="`rpm -qa gpg-pubkey*`"

if [ "$KEY" ]; then
    key=`tr [A-Z] [a-z] <<< $KEY`
    KEYS=`grep -- "-$key-" <<< "$KEYS"`
fi

LANG=C
for key in $KEYS; do

    rpm -q --nodigest --nosignature --qf "\n%{NAME}-%{VERSION}-%{RELEASE}\n" $key
    
    rpm -q $key --qf "%{DESCRIPTION}" | gpg --with-fingerprint

done
