#!/bin/bash

set -x

eval "$@"

if [ -z "${DESTDIR}" ]; then
    echo "failed: DESTDIR is not defined. Giving up"
    exit 1
fi

# if ! [ -d "${DESTDIR}" ]; then
#     echo "failed: DESTDIR ${DESTDIR} is not accessable. Giving up"
#     exit 1
# fi
mkdir -p ${DESTDIR}

install -d ${DESTDIR}/var/lib/dasscm/
install -d ${DESTDIR}/var/lib/dasscm/plugin-results/

install -d ${DESTDIR}/usr/bin
install -m 0755 usr/bin/dasscm ${DESTDIR}/usr/bin
install -m 0755 usr/bin/dasscm_remote_check.sh ${DESTDIR}/usr/bin
install -m 0755 usr/bin/dasscm_remote_update.sh ${DESTDIR}/usr/bin

install -d ${DESTDIR}/etc
install -m 0644 etc/dasscm.conf ${DESTDIR}/etc

if test -d /etc/bash_completion.d/; then
    install -d ${DESTDIR}/etc/bash_completion.d/
    install -m 644 etc/bash_completion.d/bash_completion_dasscm.sh ${DESTDIR}/etc/bash_completion.d/dasscm.sh
fi

#if test -d /etc/nagios/nrpe.d/; then
    mkdir -p ${DESTDIR}/etc/nagios/nrpe.d/
    install -m 644 etc/nagios/nrpe.d/nrpe-dasscm.cfg ${DESTDIR}/etc/nagios/nrpe.d/dasscm.cfg
#fi

install -d ${DESTDIR}/etc/profile.d/
install -m 644 etc/profile.d/dasscm.sh ${DESTDIR}/etc/profile.d/

install -d ${DESTDIR}/etc/sudoers.d/
install -m 440 etc/sudoers.d/nagios_dasscm_check ${DESTDIR}/etc/sudoers.d/

#install -d ${DESTDIR}/etc/subversion
#install -m 0644 subversion-servers.dass-it ${DESTDIR}/etc/subversion/servers.dass-it
