#
# dasscm: check status
#

CONFIG="/etc/dasscm.conf"

if [ "$HOME" ]; then
	if [ -r $CONFIG ]; then
	. $CONFIG

	# check if a warn message is wanted 
	# and dasscm is already configured ($DASSCM_REPOSITORY_NAME)
	if [ "$DASSCM_STATUS_AT_SHELL_LOGIN" = "yes" -a -n "$DASSCM_REPOSITORY_NAME" ]; then

		# check if write permissions are given
		if [ -w "${DASSCM_LOCAL_REPOSITORY_BASE}/${DASSCM_REPOSITORY_NAME}" ]; then

			# get dasscm status
			# and print it, if a result is given
			RESULT=`dasscm status`
			if [ $? -ne 0 ]; then
				printf "* DASSCM warnings *\n"
				printf "$RESULT\n"
				printf "* please use dasscm to check-in these changes *\n"
			fi
		fi
	fi
	fi
fi
