#!/bin/bash

# dasscm_remote_update is intended for systems
# where a local dasscm installation is not possible
# but ssh and rsync is available.
# In this case, 
# the files from the local repository checkout 
# are updated to the current content.
# Use only, if a local dasscm installation is not possbile!

usage()
{
echo "
  usage: $0 hostname
  hostname must be identical with the repository path
"
exit 1
}

#DRYRUN="--dry-run"
# without one-file-system, a lot of warings are produced for /proc etc.
ONEFILESYSTEM="--one-file-system"

OPTIONS="$DRYRUN $ONEFILESYSTEM"

REMOTE_USER="root"

SERVER=$1

if [ -z "$SERVER" ]; then
    usage
fi

if [ ! -d "$SERVER" ]; then
    echo
    echo "  failed to access directory $SERVER"
    usage
fi

#   start at an current repository checkout of morbo.
#   only already existing files will be updated.
#   If you want to add more files, 
#   create the file in the repository and re-run this script
svn up $SERVER || (echo "failed to update repository $SERVER"; usage)
rsync -av --existing $OPTIONS $REMOTE_USER@$SERVER:/. . || (echo "failed to access server $SERVER via ssh/rsync"; usage)
echo "updated file must be commited manually"
