#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import *
from PyQt4.QtGui import * 

import socket
import string
import random
import Ui_deploywizard

import time, difflib

import xmlrpclib
import sys
import htmldiffview

#server_url = 'https://localhost:4443'




class deploywizard(QtGui.QWizard, Ui_deploywizard.Ui_Wizard,):

  def __init__(self, serverproxy, cfgstring, daemontype, parent = None):
    super(deploywizard, self).__init__()
    self.setupUi(self)
    self.serverproxy = serverproxy
    self.diffhtml = ''
    self.cfgstring = cfgstring
    self.daemontype = daemontype
    
    
    
    self.connect(self.pushButton, QtCore.SIGNAL('clicked()'), self.showHTMLDiff)
    self.connect(self.pushButton_2, QtCore.SIGNAL('clicked()'), self.do_deployment)
    
  def initializePage(self, pagenumber):
    if pagenumber ==  1:
      
      oldconf = self.serverproxy.get_conf('dir').splitlines(True)
      
      newconf = self.cfgstring.splitlines(True)
      diffunified = difflib.unified_diff(oldconf, newconf, 'old', 'new', n=0)
      self.diffhtml = difflib.HtmlDiff(2,50).make_file(oldconf, newconf, 'old',
                                            'new', context=True,  numlines=3)
      t = ''
      for line in diffunified:
        t += line
      self.textBrowser.setText(t)
      
    #elif pagenumber ==  2:

    
  def showHTMLDiff(self):
    dialog = htmldiffview.htmldiffdialog(self)
    dialog.webView.setHtml(self.diffhtml)
    dialog.exec_()
  
  def do_deployment(self):  
      t = 'Deploying the configuration file...\n'; self.textBrowser_2.setText(t)
      t += 'transferring file to target system...\n'; self.textBrowser_2.setText(t)
      
      self.serverproxy.set_conf('dir', self.cfgstring)
      t += 'transfer completed\n'; self.textBrowser_2.setText(t)
      t += 'restarting daemon...\n'; self.textBrowser_2.setText(t)
      
      if self.daemontype == 'director':
        t += 'reLOADing director daemon...\n'; self.textBrowser_2.setText(t)
        result, out, err = self.serverproxy.reload_director()
        t += out;self.textBrowser_2.setText(t)
        if result != 0: # we cannot reload, so we try to restart
          t += 'reload failed, restarting...\n'; self.textBrowser_2.setText(t)
          t += self.serverproxy.restart_daemon(self.daemontype)[1]
      else:
        t += self.serverproxy.restart_daemon(self.daemontype)[1]
        
      t += 'checking for daemon running\n'; self.textBrowser_2.setText(t)
      
      if self.serverproxy.check_for_process('bacula-dir'):
        t += 'OK, is running'; self.textBrowser_2.setText(t)
      else:
        t += 'ERROR, is not running, rolling back...\n'; self.textBrowser_2.setText(t)
        
if __name__ == "__main__":
  
  class SafeTransportWithCert(xmlrpclib.SafeTransport):
#    __cert_file = DFLT_CERTFILE 
#    __key_file = DFLT_KEYFILE
    __cert_file = '../../certs/client-cert.pem'    # Replace with your PEM formatted key file
    __key_file = '../../certs/client-cert.pem'  # Replace with your PEM formatted certificate file

    def make_connection(self,host):
      host_with_cert = (host, {
                       'key_file' : self.__key_file,
                       'cert_file' : self.__cert_file
                       } )
      return xmlrpclib.SafeTransport.make_connection(
                                     self,host_with_cert)


  import sys
  print "started"   

  server_url = 'https://bacula-old:4443'
  transport = SafeTransportWithCert()
  serverproxy = xmlrpclib.ServerProxy(server_url,
                                 transport = transport)

  
  app = QtGui.QApplication(sys.argv)
  app.setOrganizationDomain("dass-it.de")
  app.setOrganizationName("dassIT GmbH")
  app.setApplicationName("deploywizard")
  app.setWindowIcon(QIcon(":/icons/dassit_logo.png")) 
  testconf =  open('../configs/bacula-dir.conf','r').read().decode('UTF-8')
  wizard = deploywizard(serverproxy,testconf,'director')
  wizard.exec_()

  
