
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
from PyQt4.QtWebKit import *




import Ui_messagesdialog
from nosferatu import auto_types

class MessagesDialog(QDialog, Ui_messagesdialog.Ui_MessagesDialog):
  
  def __init__(self, parent=None, messagesTypesDict=None):
    super(MessagesDialog, self).__init__(parent)
    if messagesTypesDict:
      self.msgs = messagesTypesDict
    else:
      self.msgs={}
      self.msgs['all'] = True
      for mtype in auto_types.msg_types:
        if mtype == 'all':
          continue# self.msgs[mtype] = True
        self.msgs[mtype] = True
      
    print self.msgs
    
    self.setupUi(self)
    
    self.connect(self.buttonBox, SIGNAL("accepted()"),
                     self, SLOT("accept()"))
    self.connect(self.buttonBox, SIGNAL("rejected()"),
                     self, SLOT("reject()"))
    self.setWindowTitle("Edit Message Types")
    
    
    
    i=0
    #buttonGroup = QtGui.QButtonGroup()
    #inclusiveButton = QtGui.QRadioButton('inclusive (choose the following message types)')
    #exclusiveButton = QtGui.QRadioButton('exclusive (all, except the following message types')
    #buttonGroup.addButton(inclusiveButton)
    #buttonGroup.addButton(exclusiveButton)
    #self.gridLayout_2.addWidget(inclusiveButton,1,1,1,1)
    #self.gridLayout_2.addWidget(exclusiveButton,2,1,1,1)

    
    for mtype in sorted(auto_types.msg_types):
      if mtype == 'all':
        #exclusiveButton.setChecked(self.msgs[mtype])
        continue
      msgTypeCheckbox = QtGui.QCheckBox()
      msgTypeCheckbox.setText(mtype)
      msgTypeCheckbox.setObjectName(mtype)
      
      if self.msgs[mtype] != None:
        checkstate = not(self.msgs[mtype])
      else:
        checkstate = False
      
      msgTypeCheckbox.setChecked(checkstate)
      self.connect(msgTypeCheckbox, 
                        SIGNAL("toggled(bool)"),
                         self.onCheckboxChecked )
      
      self.gridLayout.addWidget(msgTypeCheckbox,(i/2)+2, i%2, 1, 1)
      i+=1
      
    self.updateOutput()
    #self.web = QWebView()
    #self.verticalLayout.addWidget(self.web)
    
    #self.web.load(QUrl("http://www.bacula.org/5.0.x-manuals/en/main/main/Configuring_Director.html"))   
    #self.web.show()
  def onCheckboxChecked(self):
    print "checkbox was checked by:" , self.sender().objectName() , "to:" , self.sender().isChecked()
    self.msgs[str(self.sender().objectName())] = not(self.sender().isChecked())
    self.updateOutput()
    #self.sender().isChecked()

  def updateOutput(self):
    s = ''
    if self.msgs['all']:
      s += 'all,'
    for msg,val in sorted(self.msgs.iteritems()):

      if self.msgs['all']:
        if val == False:
          s += '!%s,' % (msg)
      else:# not all, so write all that are true
        if val == True:
          s += '%s,' % (msg)
    print s[:-1]
    #print self.msgs
    self.outputLineEdit.setText(s[:-1]) # cut last comma
  
  




if __name__ == "__main__":
    m={}
    m['all'] = True
    for mtype in auto_types.msg_types:
      if mtype == 'all':
        continue# self.msgs[mtype] = True
      m[mtype] = None
    m['skipped'] = False
  
    import sys
    app = QApplication(sys.argv)
    dialog = MessagesDialog(messagesTypesDict=m) 
    dialog.show()
    app.exec_()
