
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
from PyQt4.QtWebKit import *



import Ui_messagesdialog


class ListSelectDialog(QDialog, Ui_messagesdialog.Ui_MessagesDialog):
  '''
  This dialog expects a Dictionary with the possible options as keys, and
  fills the values with Frue or False. 
  '''  
  def __init__(self, parent=None, configDict=None, title='please select...'):
    super(ListSelectDialog, self).__init__(parent)
    self.setupUi(self)
    if configDict:
      self.msgs = configDict
    else:
      self.msgs={}
      
    self.setWindowTitle(title)
    self.groupBox.setTitle(title)
    #  self.msgs['all'] = True
    #  for mtype in configrules.msg_types:
    #    if mtype == 'all':
    #      continue# self.msgs[mtype] = True
    #    self.msgs[mtype] = True
      
    #print self.msgs
    
   
    
    self.connect(self.buttonBox, SIGNAL("accepted()"),
                     self, SLOT("accept()"))
    self.connect(self.buttonBox, SIGNAL("rejected()"),
                     self, SLOT("reject()"))
    #self.setWindowTitle("Edit Message Types")
    
    
    
    i=0

    
    for mtype in sorted(self.msgs.keys()):
      msgTypeCheckbox = QtGui.QCheckBox()
      msgTypeCheckbox.setText(mtype)
      msgTypeCheckbox.setObjectName(mtype)
      
      if self.msgs[mtype] != None:
        checkstate = self.msgs[mtype]
      else:
        checkstate = False
      
      msgTypeCheckbox.setChecked(checkstate)
      self.connect(msgTypeCheckbox, 
                        SIGNAL("toggled(bool)"),
                         self.onCheckboxChecked )
      
      #self.gridLayout.addWidget(msgTypeCheckbox, i%10,(i/10)+2, 1, 1)
      self.gridLayout.addWidget(msgTypeCheckbox, i, 1, 1, 1)
      i+=1
      
    self.updateOutput()
    #self.web = QWebView()
    #self.verticalLayout.addWidget(self.web)
    
    #self.web.load(QUrl("http://www.bacula.org/5.0.x-manuals/en/main/main/Configuring_Director.html"))   
    #self.web.show()
  def onCheckboxChecked(self):
    print "checkbox was checked by:" , self.sender().objectName() , "to:" , self.sender().isChecked()
    self.msgs[str(self.sender().objectName())] = self.sender().isChecked()
    self.updateOutput()
     #self.sender().isChecked()

  def updateOutput(self):
    s = ''
    for msg,val in sorted(self.msgs.iteritems()):
      if val == True:
        s += '%s,' % (msg)
    print s[:-1]
    #print self.msgs
    self.outputLineEdit.setText(s[:-1]) # cut last comma
  
  




if __name__ == "__main__":
    from nosferatu import auto_configrules
    m={}
    #m['all'] = True
    for mtype in auto_configrules.commands.keys():
      #if mtype == 'all':
      #  continue# self.msgs[mtype] = True
      m[mtype] = None
    #m['skipped'] = False
  
    import sys
    
    app = QApplication(sys.argv)
    dialog = ListSelectDialog(configDict=m,title="please select") 
    dialog.show()
    app.exec_()
