'''
Resource Objects
Created on 30.06.2009

@author: hmueller
'''


# $Id: resource.py 10982 2010-09-15 11:02:25Z pstorz $


# spezielle Ressources:
# RunScript
# FileSet
# Schedule
# 

from nosferatu.config_classes import *
import re

# possible ressourcenames
bacResourceNames = ['director', 'schedule', 'storage', 'fileset', 'client', 'pool', 'jobdefs', 'device', 'job']

class Resource(object):
    itemRegEx = re.compile('\s*([\S ]+)\s*=\s*(.*)$')
    braceRegEx = re.compile('.*[{}].*')
    closeBraceRegEx = re.compile('.*}.*')
    openBraceRegEx = re.compile('.*{.*')
    
    ''' Parse Lines of Configuration'''
    def __init__(self, configlines, name):
        self.name = name
        self.items = []
        self.comments = []
        #print self.name
        for line in configlines:
          itemLine = self.itemRegEx.match(line)
          braceLine = self.braceRegEx.match(line)
          if braceLine:
            print "Braces found; special treatment needed"
            print "this should be covered by special constructors in derivered classes"
            print line
          elif itemLine:
            self.add_item_name_value(itemLine.group(1).lower(), itemLine.group(2))
          else:
            print "ERROR: special Line:", line
            
         
        #self.DIRECTIVE = ''
    
    def __str__(self):
        s = "\n".join(self.comments)
        s += self.DIRECTIVE + " {\n"
        if self.name:
            s += "  " + "Name = " + self.name + "\n"
        for d in self.items:
            s += "  " + str(d) + "\n"
        s += "}\n"
        return s
    
    def add_comment(self, comment):
        if not comment.lstrip().startswith("#"):
            comment = "# " + comment
        self.comments.append(comment)
  
    def add_item_name_value (self, Name, Value):
        resItem = ResourceItem(Name,Value)
        print Name     
        self.items.append(resItem)
        
        
    def add_item (self,item):     
        self.items.append(item)

        
class Director(Resource):
  #
  #DirAddresses  = {
  #
  dirAdrRegEx = re.compile('\s*diraddresses\s*=\s*{(.*)',re.I)
    
  def __init__(self, configlines,name):
    # treat special config options
    inDirAddress = False
    dirAddrLines = []
    braceLevel = 0;
# TODO: Evtl dies ebenfalls im Hauptprogramm machen und dann nur die 
# referenzen eintragen?    
    for line in configlines:
      print 'LINE:' + line,
      #print ">",braceLevel, line,"<"
      dirAdrStart = self.dirAdrRegEx.match(line)
      braceLine = self.braceRegEx.match(line)
      closeBrace = self.closeBraceRegEx.match(line)
      openBrace = self.openBraceRegEx.match(line)
      
      if closeBrace:
        print "closebrace found"
        braceLevel -= 1
        if inDirAddress & braceLevel == 2:
          print "inDirAddress end"
          inDirAddress = False
      if openBrace:
        print "openBrace found"
        braceLevel += 1
      if inDirAddress:
        print "inDirAddress"
        dirAddrLines.append(line)
        configlines.remove(line)
      if dirAdrStart:
        print "DirAddress Start found"
        inDirAddress = True
        dirAddrLines.append(line)
        configlines.remove(line)
        
    Resource.__init__(self,myconfiglines,name)


#  Name = bacula-dir
#   DirAddresses  = {
#    ip = { addr = 1.2.3.4; port = 1205;}
#    ipv4 = {
#        addr = 1.2.3.4; port = http;}
#    ipv6 = {
#        addr = 1.2.3.4;
#        port = 1205;
#    }
#    ip = {
#        addr = 1.2.3.4
#        port = 1205
#    }
#    ip = { addr = 1.2.3.4 }
#    ip = { addr = 201:220:222::2 }
#    ip = {
#        addr = bluedot.thun.net
#    }
#}


class Job(Resource):
    pass

class JobDefs(Resource):
    pass

class Schedule(Resource):
    pass

class FileSet(Resource):
    pass

class Client(Resource):
    pass

class Storage(Resource):
    pass

class Pool(Resource):
    pass

class Catalog(Resource):
    pass

class Messages(Resource):
    pass

class Console(Resource):
  pass

class Counter(Resource):
    pass

class Device(Resource):
  pass

class Autochanger(Resource):
  pass






#other subconfiguration items



# DirAdresses:
#
# DirAddresses  = { 
#    ip = { addr = 1.2.3.4; port = 1205;}
#    ipv4 = {
#        addr = 1.2.3.4; port = http;}
#    ipv6 = {
#        addr = 1.2.3.4;
#        port = 1205;
#    }
#    ip = {
#        addr = 1.2.3.4
#        port = 1205
#    }
#    ip = { addr = 1.2.3.4 }
#    ip = { addr = 201:220:222::2 }
#    ip = {
#        addr = bluedot.thun.net
#    }
#}

class DirAddressItem(object):
  def __init__(self,addresstype,address,port):
    self.addresstype = addresstype # ip, ipv4, ipv6
    self.address = address         # 192.18.12.1 / www.dass-it.de
    self.port = port               # 9103 ...

  def __str__(self):
    
    s = "  " +self.addresstype + " = { \n"
    s += "    addr = " + self.address + "\n"
    if self.port:
      s += "    port = " + str(self.port) + "\n"
    s += "  }\n"
    
    return s
    
    

class DirAddresses(Resource):
  
  def __str__(self):
    s = "DirAddresses = {\n"  
    for d in self.items:
      s += str(d)
    s += "}\n"
    return s
  
  def __init__(self,name):
    self.DIRECTIVE = 'DirAddresses'
    self.comments = []
    self.items = []
    self.name = ''
  
  def add_item(self,addresstype,address,port=None):
    self.items.append( DirAddressItem( addresstype, address, port ) )
    
  def parse_string(self, string_to_parse):
    m = Resource.p.match(string_to_parse)
    if m:
      #print 'Resource:>',m.group(1),'< = >',m.group(2)
      n = m.group(1).lower().replace(' ','')
      #print  '>'+n+'<'
      if n == 'name':
        self.name = m.group(2)
      else:
        self.add_item(Item(m.group(1),m.group(2)))
      #else:
      #  print 'Resource: unbearbeiteter string: |'+string_to_parse+'|'







#  RunScript {
#    Console = "update stats days=3"
#    Console = "prune stats yes"
#    RunsWhen = After
#    RunsOnClient = no
#  }

class RunScript(Resource):
    DIRECTIVE = "RunScript"
