#!/usr/bin/env perl

use warnings;
use strict;

#use BSConfiguration;
#use BSRPC;
use BSNotify;
use Data::Dumper;

sub notify {
  my ($type, $p) = @_;
  # strip
  $p = { map {$_ => $p->{$_}} grep {defined($p->{$_}) && !ref($p->{$_})} sort keys %{$p || {}} };
  if (1) { 
	BSNotify::notify_plugins($type, $p);
  } else {
    # always route over to the src server
    print "srcserver: ", $BSConfig::srcserver, "\n";
    my $param = {
      'uri' => "$BSConfig::srcserver/notify/$type",
      'request' => 'POST',
      'headers' => [ 'Content-Type: application/x-www-form-urlencoded' ],
      'timeout' => 60,
    };
    my @args = map {"$_=$p->{$_}"} sort keys %$p;
    print Dumper( @args );
    eval {
      BSRPC::rpc($param, undef, @args);
    };
    warn($@) if $@;
  }
}

notify( 'MY_TYPE', { project => 'myprj' , 'repo' => 'myrepo' } );
