#!/usr/bin/python26
###
### backmon.commands.status.dsu
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser
from guppy import hpy

from ....lib import *

from backup_monitoring.debug import *
from backup_monitoring.math import *

from backup_monitoring.parsing.parsers import bpstulist
from backup_monitoring.parsing.parsers import nbdevquery
from backup_monitoring.parsing.parsers import bpdbjobs

usage = 'usage: %prog -e environment status dsu'

parser = OptionParser(usage=usage)
parser.add_option('-s', '--include-staging', action='store_true', default=False, dest='include_staging', help='include staging storage units')

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    (options, args) = parser.parse_args(args)

    master_feeds    = ['nbemmcmd_machinealias_getaliases', 'bpstulist', 'nbdevquery_listdv_stype_basicdisk', 'nbdevquery_listdv_stype_advanceddisk', 'nbdevquery_listdv_stype_puredisk', 'bpdbjobs_most_columns']
    media_feeds     = [ ]

    try:

        environments = ENVIRONMENTS.values()

        hp = hpy()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        for environment in environments:
            environment.load_feeds(master=master_feeds, media=media_feeds)
            environment.parse_aliases()
            environment.parse_stunits()
            environment.parse_jobs()
            environment.parse_disk_pools()

        DEBUG('HEAPSIZE=%s' % (heapsize()))

        print('%s %s %s %s %s %s %s %s %s %s' % ('ENVIRONMENT'.center(15), 'DSU'.center(25), 'TYPE'.center(12), 'SERVER'.center(8), 'STATUS'.center(6), 'JOBS'.center(4), '%FUL'.center(4), 'SIZE'.center(10), 'USED'.center(10), 'AVAIL'.center(10)))
        print('=============== ========================= ============ ======== ====== ==== ==== ========== ========== ==========')

        active_jobs = {}

        for environment in environments:

            #
            # count active backup jobs per storage unit
            #
            for job in environment.jobs:

                if job.stunit is None:
                    continue

                if job.stunit not in active_jobs:
                    active_jobs[job.stunit] = 0
                
                if job.backup and job.active:
                    active_jobs[job.stunit] += 1

            #
            # summarize other stunit statistics
            #
            for stunit in environment.stunits:

                server = environment.resolve_alias(stunit.host_connection)
                server = server.replace('-backup', '')

                if server in environment.updates:
                    monitored = True
                else:
                    monitored = False

                label               = stunit.label
                storage_unit_type   = stunit.storage_unit_type

                #
                # initialize active job counts
                #
                if label not in active_jobs:
                    active_jobs[label] = 0

                #
                # DSU specific
                #
                if storage_unit_type in ['Disk']:

                    media_subtype = stunit.media_subtype
                    disk_type = ''
                    disk_pool = None

                    size = ''
                    used = ''
                    avail = ''
                    pct_full = ''
                    status = ''
                    jobs = ''

                    #
                    # skip staging storage units (DSSUs) unless -s option was specified
                    #
                    if not options.include_staging:
                        if media_subtype == 'Basic' and stunit.stage_data == 'yes':
                            continue

                    #
                    # metrics from nbdevquery
                    #
                    if( media_subtype == 'Basic' and label in environment.disk_pools):

                        disk_pool = environment.disk_pools[label]

                    if( media_subtype == 'DiskPool' and stunit.disk_pool in environment.disk_pools):

                        disk_pool = environment.disk_pools[stunit.disk_pool]

                    if disk_pool:

                        disk_type = disk_pool.disk_type
                        size = pp_bytes(int(float(disk_pool.total_capacity_gb) * 1024.0 * 1024.0 * 1024.0))
                        used = pp_bytes(((float(disk_pool.total_capacity_gb) - float(disk_pool.free_space_gb)) * 1024.0 * 1024.0 * 1024.0))
                        avail = pp_bytes(int(float(disk_pool.free_space_gb) * 1024.0 * 1024.0 * 1024.0))

                        if( disk_pool.total_capacity_gb > 0.0 ):
                            pct_full = '%01.0f%%' % ((((float(disk_pool.total_capacity_gb) - float(disk_pool.free_space_gb)) / float(disk_pool.total_capacity_gb)) * 100.0))
                        else:
                            pct_full = '%01.0f%%' % (disk_pool.use_pct)

                        if( 'AdminUp' in disk_pool.flags and 'InternalUp' in disk_pool.flags ):
                            status = 'UP'
                        else:
                            status = 'DOWN'

                    #
                    # get active job count
                    #
                    if label in active_jobs:
                        jobs = '%d' % (active_jobs[label])

                    print('%s %s %s %s %s %s %s %s %s %s' % (environment.name.center(15), label.rjust(25), disk_type.rjust(12), server.ljust(8), status.center(6), jobs.rjust(4), pct_full.rjust(4), size.rjust(10), used.rjust(10), avail.rjust(10)))

    except Exception, e:

        #raise BackmonError, e
        raise

