#!/usr/bin/python26
###
### backmon.commands.summary
###

import sys
import os
import os.path
import glob
import re

from optparse import OptionParser

from ...lib import *

import subcommands

SUBCOMMAND_LIST = [
    'backups',
]

SUBCOMMAND_HELP = {
    'backups'   : 'backup summary statistics',
}

##
## OPTIONS
##
usage = """Usage: %prog [options] -e [ENVIRONMENT] summary [subcommand] [options] [arguments]'

  available subcommands:

""" + '\n'.join(['  %-10s       %s' % (cmd, SUBCOMMAND_HELP[cmd]) for cmd in SUBCOMMAND_LIST])

parser = OptionParser(usage=usage)

def run(args, kwargs):

    #
    # add kwargs to local namespace
    #
    for key in kwargs.keys():

        if re.compile('^[A-Z][A-Z_]+$').match(key):
            exec(key + ' = kwargs[\'' + key + '\']')

    SUBCOMMAND=None
    subcommand_pos = 0

    i = 0

    for arg in args:

        i += 1

        if arg in SUBCOMMAND_LIST:
            SUBCOMMAND = arg
            subcommand_pos = i
            break

    subcommand_args = args[subcommand_pos:]

    if SUBCOMMAND:
        (options, args) = parser.parse_args(args[:subcommand_pos])

    #
    # SUBCOMMAND
    #
    if( not SUBCOMMAND ):
        parser.print_help()
        sys.exit(1)

    DEBUG('SUBCOMMAND=%s' % (SUBCOMMAND))

    if hasattr(subcommands, SUBCOMMAND):
        exec 'subcommands.' + SUBCOMMAND + '.run(subcommand_args, locals())'
    else:
        ERROR('Invalid subcommand \'%s\'.' % (SUBCOMMAND))


