#
# SQL Dialect for SQLite
#
import generic

class Dialect(generic.Dialect):

    def __init__(self, *args, **kwargs):

        generic.Dialect.__init__(self, *args, **kwargs)

        if 'version' not in kwargs:
            self.version = '3'
        else:
            self.version = kwargs['version']

        self.name = 'SQLite Version %s' % (self.version)

        #
        # Minimum and Maximum DATETIME values
        #
        self.mindatetime = '1970-01-01 00:00:00'
        self.maxdatetime = '2038-01-19 03:14:07'

        #
        # Maximum VARCHAR length
        #
        self.maxvarchar = 'VARCHAR(2147483647)'
