import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## bpimagelist has records separated by blank lines
##
def stream(stream, format='bpimagelist -L'):

    if format in ['bpimagelist -L']:
        return BlankLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpimagelist record
##
##     bpimagelist -L
##
def parse(record, format='bpimagelist -L', version=None, tz=None):

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')
    re_type_id = re.compile('^([0-9a-zA-Z\-_ ]+)\s+\((\d+)\)$')
    re_id_type = re.compile('^(\d+)\s+\(([0-9a-zA-Z\-_ ]+)\)$')
    re_in_parens = re.compile('^\((.*)\)$')
    re_starts_with_time = re.compile('^time_.*$')
    re_ends_with_time = re.compile('^.*_time$')
    re_time_plus_epoch_seconds_in_parens = re.compile('^.*\d:\d\d:\d\d.*\((\d+)\)$')
    re_epoch_seconds_plus_time_in_parens = re.compile('^(\d+)\s+\(.*\d:\d\d:\d\d.*\)$')
    re_nbu_infinity = re.compile('^.*INFINITY\s+\((\d+)\)$')
    re_unix_time_hack = re.compile('^.*\((\d+)\)$')

    image = ExtendedDict()

    if format == 'bpimagelist -L':

        header = True

        try:

            i = 0

            #
            # process image header
            #
            while header and i < len(record):

                line = record[i]

                i += 1

                match = re_pair.match(line)

                key     = match.group(1)
                value   = match.group(2)
                value   = value.rstrip()
                key     = key.lower()
                key     = key.rstrip()
                key     = key.replace('-', '_')
                key     = key.replace(' ', '_')

                if key == 'copy_number':
                    header = False
                else:

                    #
                    # convert text values to python datatypes
                    #
                    while True:

                        #
                        # match timestamp with Unix time in parentheses
                        #
                        match = re_time_plus_epoch_seconds_in_parens.match(line)
                        if match:
                            value = datetime.datetime.fromtimestamp(float(match.group(1)), tz)
                            break

                        #
                        # match infinity
                        #
                        match = re_nbu_infinity.match(value)
                        if match:
                            value = datetime.datetime.fromtimestamp(float(match.group(1)), tz)
                            break

                        #
                        # separate type and id
                        #
                        match = re_type_id.match(value)
                        if match:
                            idkey = '%s_id' % (key)
                            value = match.group(1)
                            image[idkey] = int(match.group(2))
                            break

                        #
                        # separate id and type
                        #
                        match = re_id_type.match(value)
                        if match:
                            idkey = '%s_id' % (key)
                            value = match.group(2)
                            image[idkey] = int(match.group(1))
                            break

                        #
                        # strip enclosing parens
                        #
                        match = re_in_parens.match(value)
                        if match:
                            value = match.group(1)
                            break

                        #
                        # ..otherwise autodetect
                        #
                        value = autotype(value)
                        break

                    #
                    # store value
                    #
                    image[key] = value

            #
            # parse image copies
            #
            copies = ExtendedDict()
            image['copies'] = copies

            #
            # return the image if there are no copies and we have reached the end of the record
            #
            if i == len(record):
                return image

            i = i - 1

            while i < len(record):

                line = record[i]

                match = re_pair.match(line)

                key     = match.group(1)
                value   = match.group(2)
                value   = value.rstrip()
                key     = key.lower()
                key     = key.rstrip()
                key     = key.replace('-', '_')
                key     = key.replace(' ', '_')

                #
                # identify current copy
                #
                if key == 'copy_number':

                    copy_number = int(value)

                    if copy_number not in copies:
                        copies[copy_number] = ExtendedDict()
                        copies[copy_number]['copy_number'] = copy_number
                        copies[copy_number]['fragments'] = ExtendedDict()

                #
                # identify current fragment
                #
                elif key == 'fragment':

                    if value == 'TIR (-1)':
                        fragment =  -1
                        tir = True
                    elif value == 'TIR (-2)':
                        fragment = -2
                        tir = True
                    else:
                        fragment = int(value)
                        tir = False

                    if fragment not in copies[copy_number].fragments:
                        copies[copy_number].fragments[fragment] = ExtendedDict()
                        copies[copy_number].fragments[fragment]['fragment'] = fragment
                        copies[copy_number].fragments[fragment]['tir'] = tir

                #
                # save the key and value using the copy and fragment
                #
                else:

                    while True:

                        #
                        # match timestamp with Unix time in parentheses
                        #
                        match = re_time_plus_epoch_seconds_in_parens.match(line)
                        if match:
                            value = datetime.datetime.fromtimestamp(float(match.group(1)), tz)
                            break

                        #
                        # match infinity
                        #
                        match = re_nbu_infinity.match(value)
                        if match:
                            value = datetime.datetime.fromtimestamp(float(match.group(1)), tz)
                            break

                        #
                        # separate type and id
                        #
                        match = re_type_id.match(value)
                        if match:
                            idkey = '%s_id' % (key)
                            value = match.group(1)
                            copies[copy_number].fragments[fragment][idkey] = int(match.group(2))
                            break

                        #
                        # ..otherwise autodetect
                        #
                        value = autotype(value, tz=tz)
                        break

                    copies[copy_number].fragments[fragment][key] = value

                i += 1

            image['copies'] = copies

            return image

        except Exception, e:

            for line in record:
                print line

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

