import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## sis status -l has records separated by blank lines
##
def stream(stream, format='sis status -l'):

    if format in ['sis status -l']:
        return BlankLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a sis status record
##
##     sis status -l
##
def parse(record, format='sis status -l', version=None, tz=None):

    obj = ExtendedDict()

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')

    if format == 'sis status -l':

        try:

            for line in record:

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')

                #
                # convert text values to python datatypes
                #
                while True:

                    #
                    # convert to integer value
                    #
                    match = re_integer.match(value)
                    if match:
                        value = int(value)
                        break

                    #
                    # break out of enclosing while loop
                    #
                    break

                obj[key] = value

            return obj

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

