import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## bpstulist has records separated by blank lines
##
def stream(stream, format='bpstulist -L'):

    if format in ['bpstulist -L']:
        return BlankLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a bpstulist record
##
##     bpstulist -L
##
def parse(record, format='bpstulist -L', version=None, tz=None):

    stunit = ExtendedDict()

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')
    re_type_id = re.compile('^([0-9a-zA-Z\-_ ]+)\s+\((\d+)\)$')
    re_quoted_string = re.compile('^[\'"].*[\'"]$')

    if format == 'bpstulist -L':

        try:

            for line in record:

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')

                #
                # convert text values to python datatypes
                #
                while True:

                    #
                    # convert to integer value
                    #
                    match = re_integer.match(value)
                    if match:
                        value = int(value)
                        break

                    #
                    # remove quotes from quoted string
                    #
                    match = re_quoted_string.match(value)
                    if match:
                        value = value[1:-1]
                        break

                    #
                    # separate type and id
                    #
                    match = re_type_id.match(value)
                    if match:
                        idkey = '%s_id' % (key)
                        value = match.group(1)
                        stunit[idkey] = int(match.group(2))
                        break

                    #
                    # separate robot type, id, and number
                    #
                    if key == 'robot_type_number':

                        robot_type, robot_number = value.split(' / ')

                        match = re_type_id.match(robot_type)
                        if match:
                            robot_type = match.group(1)
                            stunit['robot_type_id'] = match.group(2)

                        stunit['robot_type'] = robot_type
                        stunit['robot_number'] = robot_number

                        break
                        
                    #
                    # separate robot type and id
                    #
                    if key == 'robot_type':
                        if value == '(not robotic)':
                            value = None
                            break

                    #
                    # break out of enclosing while loop
                    #
                    break

                stunit[key] = value

            return stunit

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

