import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## vmpool has records separated by a line of = characters
##
def stream(stream, format='vmpool -list_all'):

    if format in ['vmpool -list_all', 'vmpool -listall']:
        return LineSeparatorStream(stream, separator='================================================================================', header=1)
    elif format in ['vmpool -list_scratch']:
        return LineSeparatorStream(stream, separator='=============', header=2)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a vmpool record
##
##     vmpool -listall
##
def parse(record, format='vmpool -listall', version=None, tz=None):

    pool = ExtendedDict()
    re_pair = re.compile('^([^:]+):\s*(.*)$')

    if format in ['vmpool -list_all', 'vmpool -listall']:

        try:

            for line in record:

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')

                #
                # Convert to integer value
                #
                if re_integer.match(value):
                    value = int(value)

                pool[key] = value

            return pool

        except Exception, e:

            raise ParseError, e

    elif format in ['vmpool -list_scratch']:

        try:

            return record[0]

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)


