
import re

re_fqdn = re.compile('^([a-zA-Z0-9\-_]+).([a-zA-Z0-9\-_.]+)$')

##
## strip_domain() - strip the domain from a fully-qualified hostname
##
def strip_domain(hostname):

    match = re_fqdn.match(hostname)

    if match:
        return match.group(1)
    else:
        return hostname


