
import re
import struct

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

def vmoprcmd_validate(data):

    for line in data:
        if re.compile(r'^\s+PENDING REQUESTS\s+$').match(line):
            return True
        if re.compile(r'^\s+DRIVE STATUS\s+$').match(line):
            return True
        if re.compile(r'^\s+ADDITIONAL DRIVE STATUS\s+$').match(line):
            return True

    return false

def vmoprcmd_split(data):

    pending_requests        = []
    drive_status            = []
    additional_drive_status = []
    lines                   = []
    current_section         = None

    i = 0
    j = len(data)

    while( i < j ):
        line = data[i]
        i += 1
        if re.compile(r'^\s+PENDING REQUESTS\s+$').match(line):
            print 'PROCESSING PENDING REQUESTS'
            current_section = 'PENDING REQUESTS'
            lines = pending_requests
            continue
        if re.compile(r'^\s+DRIVE STATUS\s+$').match(line):
            print 'PROCESSING DRIVE STATUS'
            current_section = 'DRIVE STATUS'
            lines = drive_status
            continue
        if re.compile(r'^\s+ADDITIONAL DRIVE STATUS\s+$').match(line):
            print 'PROCESSING ADDITIONAL DRIVE STATUS'
            current_section = 'ADDITIONAL DRIVE STATUS'
            lines = additional_drive_status
            continue
        if re.compile(r'^$').match(line):
            continue
        if current_section == 'PENDING REQUESTS' and re.compile(r'^\s+<NONE>\s+$').match(line):
            continue
        if current_section == 'DRIVE STATUS' and re.compile(r'^Drv').search(line):
            continue
        if current_section == 'ADDITIONAL DRIVE STATUS' and re.compile(r'^Drv').search(line):
            continue
        lines.append(line)
    return (pending_requests, drive_status, additional_drive_status)


def drive_status_parse(data):

    ds = {}

    for line in data:
        line = line[:-1]
        print line
        (drv, type, control, user, label, recmid, extmid, ready, wrenbl, reqid) = struct.unpack('3sx6sx8sx9sx6sx7sx7sx7sx9sx5s', line)
        ds['drv'    ] = drv
        ds['type'   ] = type
        ds['control'] = control
        ds['user'   ] = user
        ds['label'  ] = label
        ds['recmid' ] = recmid
        ds['extmid' ] = extmid
        ds['ready'  ] = ready
        ds['wrenbl' ] = wrenbl
        ds['reqid'  ] = reqid
        for key in ds.keys():
            ds[key] = ds[key].lstrip().rstrip()
            if ds[key] == '' or ds[key] == '-':
                ds[key] = None
        print 'Drv Type   Control  User      Label  RecMID  ExtMID  Ready   Wr.Enbl.  ReqId'
        print '%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|' % (ds['drv'], ds['type'], ds['control'], ds['user'], ds['label'], ds['recmid'], ds['extmid'], ds['ready'], ds['wrenbl'], ds['reqid'])




def additional_drive_status_parse(data):

    ds = {}

    for line in data:
        line = line[:-1]
        print line
        (drv, drivename, shared, assigned, comment) = struct.unpack('3sx20sx9sx15sx26s', line)
        ds['drv'       ] = drv
        ds['drivename' ] = drivename
        ds['shared'    ] = shared
        ds['assigned'  ] = assigned
        ds['comment'   ] = comment
        for key in ds.keys():
            ds[key] = ds[key].lstrip().rstrip()
            if ds[key] == '' or ds[key] == '-':
                ds[key] = None
        print 'Drv DriveName            Shared    Assigned        Comment'
        print '%s|%s|%s|%s|%s|' % (ds['drv'], ds['drivename'], ds['shared'], ds['assigned'], ds['comment'])

