import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## ontap df has one record per-line
##
def stream(stream, format='df -s'):

    if format in ['df -s']:
        return NewLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse an ontap df record
##
def parse(record, format='df -s', version=None, tz=None):

    fs = ExtendedDict()

    if format == 'df -s':

        regex = re.compile('^(\S+)\s+(\d+)\s+(\d+)\s+(\d+)%.*$')

        try:

            match = regex.match(record)

            filesystem = match.group(1)

            if filesystem[-1] == '/':
                filesystem = filesystem[:-1]

            fs['filesystem']    = filesystem
            fs['used']          = long(match.group(2))
            fs['saved']         = long(match.group(3))
            fs['pct_saved']     = int(match.group(4))

            return fs

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
