import re

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...streams import *

##
## reallocate status -v has records separated by blank lines
##
def stream(stream, format='reallocate status -v'):

    if format in ['reallocate status -v']:
        return BlankLineStream(stream, header=1)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a reallocate status record
##
##     reallocate status -v
##
def parse(record, format='reallocate status -v', version=None, tz=None):

    obj = ExtendedDict()

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')

    if format == 'reallocate status -v':

        try:

            if record[0] == 'No reallocation status.':
                return None
            else:
                obj['volume'] = record.pop(0)[:-2]

            for line in record:

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')

                #
                # convert text values to python datatypes
                #
                while True:

                    #
                    # convert to integer value
                    #
                    match = re_integer.match(value)
                    if match:
                        value = int(value)
                        break

                    #
                    # process flags
                    #
                    if key == 'flags':

                        flags = []

                        for flag in value.split(','):
                            flags.append(flag)

                        value = flags

                    #
                    # break out of enclosing while loop
                    #
                    break

                obj[key] = value

            return obj

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)

