#
# SQL Dialect for MySQL
#
import generic

class Dialect(generic.Dialect):

    def __init__(self, *args, **kwargs):

        generic.Dialect.__init__(self, *args, **kwargs)

        if 'version' not in kwargs:
            self.version = '5'
        else:
            self.version = kwargs['version']

        self.name = 'MySQL Version %s' % (self.version)

        #
        # Minimum and Maximum DATETIME values
        #
        self.mindatetime = '1970-01-01 00:00:00'
        self.maxdatetime = '2038-01-19 03:14:07'

        #
        # Maximum VARCHAR length
        #
        self.maxvarchar = 'VARCHAR(65535)'

        #
        # Statement Terminator
        #
        self.go = ';'

        #
        # Timestamp Data Type
        #
        self.timestamp = 'TIMESTAMP'
