#
# SQL Dialect for Microsoft SQL Server
#
import generic

class Dialect(generic.Dialect):

    def __init__(self, *args, **kwargs):

        generic.Dialect.__init__(self, *args, **kwargs)

        if 'version' not in kwargs:
            self.version = '2000'
        else:
            self.version = kwargs['version']

        self.name = 'Microsoft SQL Server %s' % (self.version)

        #
        # Minimum and Maximum DATETIME values
        #
        self.mindatetime = '1753-01-01 00:00:00'
        self.maxdatetime = '9999-12-31 00:00:00'

        #
        # Big Integer values
        #
        self.bigint = 'BIGINT'

        #
        # Small Integer values
        #
        self.smallint = 'SMALLINT'

        #
        # Maximum VARCHAR length
        #
        self.maxvarchar = 'VARCHAR(8000)'
