#
# Generic SQL Dialect
#
class Dialect(object):

    def __init__(self):

        self.datatypes = {}

        #
        # Big Integer values
        #
        self.bigint = 'INTEGER'

        #
        # Small Integer values
        #
        self.smallint = 'INTEGER'

        #
        # Maximum VARCHAR length
        #
        self.maxvarchar = 'VARCHAR(255)'

        #
        # Statement Terminator
        #
        self.go = 'GO'

        #
        # Timestamp Data Type
        #
        self.timestamp = 'DATETIME'

    #
    # name is left padded to length n
    #
    def lpad(self, name, n):

        fmt = '%%%ss' % (n)

        return fmt % (getattr(self, name))

    #
    # name is right padded to length n
    #
    def rpad(self, name, n):

        fmt = '%%-%ss' % (n)

        return fmt % (getattr(self, name))

