import re

import time
import datetime
import pytz

from ....builtins import *

from ...exceptions import *
from ...expressions import *
from ...autotype import *
from ...streams import *

##
## nbdevquery has records separated by blank lines
##
def stream(stream, format='nbdevquery -listdv -U -stype BasicDisk'):

    if format in ['nbdevquery -listdv -U -stype BasicDisk', 'nbdevquery -listdv -U -stype AdvancedDisk', 'nbdevquery -listdv -U -stype PureDisk']:
        return BlankLineStream(stream, header=0)
    else:
        raise ParseError, 'Unknown format %s' % (format)


##
## Parse a nbdevquery record
##
##     nbdevquery -listdv -U -stype BasicDisk
##
def parse(record, format='nbdevquery -listdv -U -stype BasicDisk', version=None, tz=None):

    re_pair = re.compile('^\s*([^:]+):\s*(.*)\s*$')
    re_type_id = re.compile('^([0-9a-zA-Z\-_ ]+)\s+\((\d+)\)$')
    re_id_type = re.compile('^(\d+)\s+\(([0-9a-zA-Z\-_ ]+)\)$')
    re_in_parens = re.compile('^\((.*)\)$')
    re_starts_with_time = re.compile('^time_.*$')
    re_ends_with_time = re.compile('^.*_time$')
    re_time_plus_epoch_seconds_in_parens = re.compile('^.*\d:\d\d:\d\d.*\((\d+)\)$')
    re_epoch_seconds_plus_time_in_parens = re.compile('^(\d+)\s+\(.*\d:\d\d:\d\d.*\)$')

    re_trailing_whitespace = re.compile('\s+$')
    re_strip_trailing_whitespace = re.compile('^(.*\S)\s*$')

    pool = ExtendedDict()
    pool['flags'] = ExtendedDict()

    if format in ['nbdevquery -listdv -U -stype BasicDisk', 'nbdevquery -listdv -U -stype AdvancedDisk', 'nbdevquery -listdv -U -stype PureDisk']:

        try:

            for line in record:

                match = re_pair.match(line)

                key = match.group(1)
                value = match.group(2)

                key = key.rstrip()
                value = value.rstrip()

                key = re.sub('\s+', ' ', key)
                key = key.lower()
                key = key.replace(' ', '_')
                key = key.replace('/', '_')
                key = key.replace('(', '')
                key = key.replace(')', '')
                key = key.replace('%', '_pct')

                #
                # convert to python datatypes
                #
                while True:

                    #
                    # convert to integer value
                    #
                    if re_integer.match(value):
                        value = int(value)
                        break

                    #
                    # convert to floating point value
                    #
                    if re_float.match(value):
                        value = float(value)
                        break

                    #
                    # break if nothing matched
                    #
                    break

                #
                # if flag, add value to flags
                #
                if key == 'flag':
                    pool.flags[value] = True
                else:
                    pool[key] = value

            return pool

        except Exception, e:

            raise ParseError, e

    else:

        raise ParseError, 'Unknown format %s' % (format)
