###
### Math Functions
###
import math
#import cmath
#import Numeric

##
## Pad a value in microseconds so that it can be added as a string following the decimal
## to an integer value to produce a float.
##
def micropad(microseconds):
    digits = '%s' % (microseconds)
    digit_count = len(digits)
    if digit_count < 6:
        for i in range(6 - digit_count):
            digits = '%s%s' % (0, digits)
    return digits

##
## pp_bytes(bytes) - Pretty print a number of bytes with conversion to higher units
##
def pp_bytes(bytes, format='%7.2f %s'):

    if bytes < 1024:
        suffix = ' B'
    elif bytes >= 1024 and bytes < 1048576:
        bytes = bytes / 1024.0
        suffix = 'KB'
    elif bytes >= 1048576 and bytes < 1073741824:
        bytes = bytes / 1024.0 / 1024.0
        suffix = 'MB'
    elif bytes >= 1073741824 and bytes < 1099511627776:
        bytes = bytes / 1024.0 / 1024.0 / 1024.0
        suffix = 'GB'
    elif bytes >= 1099511627776 and bytes < 1125899906842624:
        bytes = bytes / 1024.0 / 1024.0 / 1024.0 / 1024.0
        suffix = 'TB'
    elif bytes >= 1125899906842624 and bytes < 1152921504606846976:
        bytes = bytes / 1024.0 / 1024.0 / 1024.0 / 1024.0 / 1024.0
        suffix = 'PB'

    return format % (bytes, suffix)


##
## pp_kytes(kytes) - Pretty print a number of kytes with conversion to higher units
##
def pp_kbytes(kbytes, format='%7.2f %s'):

    return pp_bytes(kbytes*1024.0, format=format)
