#!/usr/bin/python

import sys
import time

pids={}

def parse_execve(syscall):
  i=syscall.find('"')
  if i<0:
    return None
  name=syscall[i+1:]
  i=name.find('"')
  if i<0:
    return None
  name=name[:i]
  return name

def parse_exit(syscall):
  i=syscall.find(',')
  retcode=syscall[len('_exit('):i]
  return retcode

def parse_waitpid(syscall):
  i=syscall.rfind('=')
  if i<0:
    return None
  else:
    pid=syscall[i+1:].strip()
    pid=pid.split(' ')[0]
    return pid
  
def process_syscall(pid,t,syscall):
  if syscall.startswith('execve') and not "ENOENT" in syscall:
    name=parse_execve(syscall)
    i=name.rfind('/')
    if i>0:
      name=name[i+1:]
    pids[pid]=[ name,t ]
  elif syscall.startswith('_exit'):
    if pids.has_key(pid):
      name,start=pids[pid]
      pids[pid]=[ name,start,t ]
  elif 'waitpid' in syscall:
    pid=parse_waitpid(syscall)
    if pids.has_key(pid):
      name,start=pids[pid]
      pids[pid]=[ name,start,t]

if __name__=="__main__":
  for l in sys.stdin.readlines():
    parts=l.split(" ")
    pid=parts[0]
    t=parts[1]
    syscall=''.join(parts[2:])
    
    process_syscall(pid,t,syscall)
    

  for p in sorted(pids):
    tup=pids[p]
    if len(tup)==2:
      name,start=tup
      print name+"*",start,start
    else:
      name,start,end=tup
      print name,start,end
