#!/usr/bin/perl -w
# automatisches buildskript fuer smartclient
# liest die konfiguration aus der mit -b bergebenen Datei
# $Id: buildall.pl,v 1.1 2002/09/03 14:13:10 pstorz Exp $
use Getopt::Std;

# Programmoptionen: -b (buildlist) 

my $smartclient_root="../../";   # Pfad, zu dem die Pfade in buildlist stehen
my $build = "/home/pstorz/bin/build.sh";
our ($opt_b);
my @ArrayofBuilds;
getopts('b:');

(open(BUILDLIST,$opt_b)) || die "Die Buildlist $opt_b  konnte nicht gefunden werden";


while (<BUILDLIST>) #Buildlist parsen
  {
    next if (/^\#.*$/);
    if (/([\w\/]+)\s*:([\/\w\-\+\.]+)\s+:?((\s*\-\-\w*)*)$/)
      {
	($dir, $arch, $opt) = ($1, $2, $3);
	chomp ($arch);
	@build=($dir, $arch, $opt);
	push @ArrayofBuilds, [@build];
      }
  }

for $i (0 .. $#ArrayofBuilds)
  {
  print("$ArrayofBuilds[$i][0]\t$ArrayofBuilds[$i][1]\t$ArrayofBuilds[$i][2]\n");
  $mypath = $smartclient_root.$ArrayofBuilds[$i][0];

  if ($ArrayofBuilds[$i][2])
    {
      $ENV{'BUILD_MODE'}=$ArrayofBuilds[$i][2];
    }
  else 
    {
      $ENV{'BUILD_MODE'}="--clean";
    }
  $ENV{'BUILD_DIST'}=$ArrayofBuilds[$i][1];
#  system "./test.sh";
  $_=$ArrayofBuilds[$i][0];
  print "$_ \n";
  tr/\//\_/;
  $logfilename = $_.".log";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
  print "executing command: cd $mypath; $build 2>&1 |tee $logfilename\n";
  print "BUILD_DIST ist $ENV{'BUILD_DIST'}\n";
  print "BUILD_MODE ist $ENV{'BUILD_MODE'}\n";

  print "writing logfile to $logfilename \n";
  print "++++++++++++++++++++++++++++++++++++++++++\n";
# system "cd $mypath; $build 2>&1 > $logfilename;"
 system "cd $mypath; $build 2>&1 |tee $logfilename;"
}

print "buildall.pl terminated\n";



