#!/bin/bash
# Remote build script (iboernig@suse.de)
# $Id: build.sh,v 1.7 2002/09/04 14:19:54 pstorz Exp $
#
# Kurze Featuritis:
# - build.sh sollte im Pfad liegen ~/bin ist eine gute Wahl ;)
# - build.sh erzeugt mit Hilfe des Makefiles in jedem smartclient Verzeichnis
#   ein tar-Archiv, bertrgt dieses nach Oldwotan und baut es dort
# - Dazu muss ein ssh-pubkey in oldwotans /root/.ssh/authorized_keys gelegt 
#   werden (build.sh verwendet ssh)
# Wichtige Einstellungen:
# - Standardmig baut build.sh mit --clean, wenns schnell gehen soll, die 
#   Umgebungsvariable BUILD_MODE="--no-init" exportieren
# - BUILD_DIST ist standard sles7-i386, kann auch durch entsprechenden Export
#   berschrieben werden.
# - ist BUILD_ROOT nicht gesetzt baut build.sh in der Umgebung 
#   /abuild/buildsystem.oldwotan.smartclient, um nicht mit Userumgebungen zu 
#   kollidieren. 
# - die fertigen Pakete werden nach DEST_DIR (kann durch env gesetzt werden) 
#   in die vorgegebene Hierarchie (src, i386/sles/7) auf den lokalen Rechner 
#   kopiert. Vorgabe ist /tmp/smartclient_build

SSH_VERSION="1"
BUILDHOST="oldwotan"
FQBUILDHOST="$BUILDHOST.suse.de"
BUILDTEMP=abuildtmp
BUILDUSER=$USER
# setzen der Zielarchtitektur. Wird bei Bedarf durch noarch berschrieben.
ARCH=i386
OS_TYPE=sles
OS_VER=7

[ -z "$BUILD_MODE" ] && BUILD_MODE="--clean"
[ -z "$BUILD_DIST" ] && BUILD_DIST="${OS_TYPE}${OS_VER}-$ARCH"
[ -z "$BUILD_ROOT" ] && BUILD_ROOT="/abuild/buildsystem.$BUILDHOST.$USER.$BUILD_DIST.smartclient"
[ -z "$BUILD_PREPARE_SPEC" ] && BUILD_PREPARE_SPEC="no"

[ -z $DEST_DIR ] && DEST_DIR="/tmp/smartclient_build/$BUILD_DIST"

# Hier gehts los:
make

SPECFILE=$(ls *.spec | awk '{print $1}')
TARFILE=$(ls  *.tar.[gb]z*| awk '{print $1}')
DIFFILES=$(ls *.dif* 2>/dev/null | awk '{print $1}')

# sonstige files die gebraucht werden
RESTFILES=$(ls *.init 2>/dev/null | awk '{print $1}') # fuer srpm inetd

PACKAGE=$(awk '/^Name:/ {print $2}' <$SPECFILE)
VERSION=$(awk '/^Version:/ {print $2}' <$SPECFILE)

BUILDARCH=$(awk '/^BuildArch:/ {print $2}' <$SPECFILE)
[ -z "$BUILDARCH" ] && BUILDARCH=$ARCH

echo $PACKAGE $VERSION $ARCH $BUILDARCH

# Cleaning up and install tempdir
ssh -${SSH_VERSION} ${FQBUILDHOST} "rm -r ${BUILDTEMP}/src/${PACKAGE}-${VERSION}; \
			mkdir -p ${BUILDTEMP}/src/${PACKAGE}-${VERSION}; \
			mkdir -p ${BUILDTEMP}/${ARCH}/${OS_TYPE}/${OS_VER}"

scp -oProtocol=$SSH_VERSION $TARFILE $SPECFILE $DIFFILES $RESTFILES ${FQBUILDHOST}:${BUILDTEMP}/src/${PACKAGE}-${VERSION}

# create buildscript

cat > /tmp/tmpscript.$$ <<EOF
#!/bin/bash
# local buildscript
. /work/src/bin/.profile
export BUILD_ROOT=$BUILD_ROOT
export BUILD_DIST=$BUILD_DIST
export BUILD_PREPARE_SPEC=$BUILD_PREPARE_SPEC

echo "BUILD_PREPARE_SPEC ist $BUILD_PREPARE_SPEC";


cd ~${BUILDUSER}/${BUILDTEMP}/src/${PACKAGE}-${VERSION}
build $BUILD_MODE  	--prefer-rpms ~${BUILDUSER}/${BUILDTEMP}/$ARCH/$OS_TYPE/$OS_VER 
EOF

cat /tmp/tmpscript.$$

scp -oProtocol=$SSH_VERSION /tmp/tmpscript.$$ ${FQBUILDHOST}:${BUILDTEMP}/src/${PACKAGE}-${VERSION}/buildscript
rm /tmp/tmpscript.$$

# build and file rpms
ssh -oProtocol=$SSH_VERSION root@${FQBUILDHOST} \
	. ~$BUILDUSER/${BUILDTEMP}/src/${PACKAGE}-${VERSION}/buildscript
ssh -oProtocol=$SSH_VERSION ${FQBUILDHOST} \
	cp ${BUILD_ROOT}/usr/src/packages/RPMS/${BUILDARCH}/${PACKAGE}-${VERSION}-*.${BUILDARCH}.rpm ${BUILDTEMP}/$ARCH/$OS_TYPE/$OS_VER/

mkdir -p ${DEST_DIR}/src

if !(scp -oProtocol=$SSH_VERSION root@${FQBUILDHOST}:${BUILD_ROOT}/usr/src/packages/SRPMS/${PACKAGE}-${VERSION}-*.src.rpm ${DEST_DIR}/src;)
    then 
    echo "ERROR while building packet $PACKAGE";
    echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;
    sleep 10;
fi

mkdir -p ${DEST_DIR}/$ARCH/$OS_TYPE/$OS_VER
if !(scp -oProtocol=$SSH_VERSION root@${FQBUILDHOST}:${BUILD_ROOT}/usr/src/packages/RPMS/${BUILDARCH}/${PACKAGE}-${VERSION}-*.${BUILDARCH}.rpm ${DEST_DIR}/$ARCH/$OS_TYPE/$OS_VER;)
    then 
    echo "ERROR while building packet $PACKAGE";
    echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;echo "";sleep 1;
    sleep 10;
    exit 1;
fi

echo "Build of ${PACKAGE} completed!"
echo "Packages can be found in ${DEST_DIR}"
