/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import org.jibx.runtime.impl.IInByteBuffer;

public class InByteBuffer
implements IInByteBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream m_stream;
    private boolean m_isEnd;
    private byte[] m_buffer;
    private int m_limit;
    private int m_offset;

    public InByteBuffer(int size) {
        this.m_buffer = new byte[size];
    }

    public InByteBuffer() {
        this(4096);
    }

    private boolean fillBuffer(int size) throws IOException {
        int rem;
        if (this.m_isEnd) {
            return false;
        }
        byte[] oldbuf = this.m_buffer;
        if (this.m_buffer.length < size) {
            byte[] newbuf = new byte[Math.max(size, this.m_buffer.length * 2)];
            this.m_buffer = newbuf;
        }
        if ((rem = this.m_limit - this.m_offset) > 0) {
            System.arraycopy(oldbuf, this.m_offset, this.m_buffer, 0, rem);
        }
        this.m_offset = 0;
        int max = this.m_buffer.length - rem;
        int actual = this.m_stream.read(this.m_buffer, rem, max);
        if (actual >= 0) {
            this.m_limit = rem + actual;
            return true;
        }
        this.m_limit = rem;
        this.m_isEnd = true;
        return false;
    }

    public void reset() {
        this.m_isEnd = false;
        this.m_limit = 0;
        this.m_offset = 0;
        this.m_stream = null;
    }

    public void setInput(InputStream is) {
        try {
            this.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reset();
        this.m_stream = is;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public int getLimit() {
        return this.m_limit;
    }

    public boolean require(int size) throws IOException {
        while (this.m_limit - this.m_offset < size) {
            if (this.fillBuffer(size)) continue;
            return false;
        }
        return true;
    }

    public void finish() throws IOException {
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
    }
}

