/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.Base64;

public class SASLGSSAPIMechanism
extends SASLMechanism {
    private static final String protocol = "xmpp";
    private static final String[] mechanisms = new String[]{"GSSAPI"};
    private SaslClient sc;

    public SASLGSSAPIMechanism(SASLAuthentication saslAuthentication) {
        super(saslAuthentication);
        System.setProperty("java.security.krb5.debug", "true");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        System.setProperty("java.security.auth.login.config", "gss.conf");
    }

    protected String getName() {
        return "GSSAPI";
    }

    public void authenticate(String username, String host, String password) throws IOException {
        byte[] response;
        String authenticationText;
        StringBuffer stanza = new StringBuffer();
        HashMap props = new HashMap();
        this.sc = Sasl.createSaslClient(mechanisms, username, protocol, host, props, null);
        stanza.append("<auth mechanism=\"").append(this.getName());
        stanza.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        if (this.sc.hasInitialResponse() && (authenticationText = Base64.encodeBytes(response = this.sc.evaluateChallenge(new byte[0]), 8)) != null && !authenticationText.equals("")) {
            stanza.append(authenticationText);
        }
        stanza.append("</auth>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    protected String getAuthenticationText(String username, String host, String password) {
        return null;
    }

    public void challengeReceived(String challenge) throws IOException {
        StringBuffer stanza = new StringBuffer();
        byte[] response = challenge != null ? this.sc.evaluateChallenge(Base64.decode(challenge)) : this.sc.evaluateChallenge(null);
        String authenticationText = Base64.encodeBytes(response, 8);
        if (authenticationText.equals("")) {
            authenticationText = "=";
        }
        stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stanza.append(authenticationText);
        stanza.append("</response>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    protected String getChallengeResponse(byte[] bytes) {
        return null;
    }
}

