/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLReader;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.DescriptionElement;

public abstract class WSDLFactory {
    private static final String PROPERTY_NAME = "org.apache.woden.WSDLFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "org.apache.woden.internal.DOMWSDLFactory";
    private static String fFullPropertyFileName = null;

    public static WSDLFactory newInstance() throws WSDLException {
        String factoryImplName = WSDLFactory.findFactoryImplName();
        return WSDLFactory.newInstance(factoryImplName);
    }

    public static WSDLFactory newInstance(String factoryImplName) throws WSDLException {
        if (factoryImplName != null) {
            try {
                Class<?> cl = Class.forName(factoryImplName);
                return (WSDLFactory)cl.newInstance();
            }
            catch (Exception e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating a WSDLFactory implementation using factory impl name '" + factoryImplName + "' ", e);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find the name of a WSDLFactory implementation class.");
    }

    private static String findFactoryImplName() throws WSDLException {
        String factoryImplName = null;
        try {
            factoryImplName = System.getProperty(PROPERTY_NAME);
            if (factoryImplName != null) {
                return factoryImplName;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String propFileName = WSDLFactory.getFullPropertyFileName();
        if (propFileName != null) {
            try {
                Properties properties = new Properties();
                File propFile = new File(propFileName);
                FileInputStream fis = new FileInputStream(propFile);
                properties.load(fis);
                fis.close();
                factoryImplName = properties.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (FileNotFoundException e1) {
            }
            catch (IOException e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem loading the properties file '" + propFileName + "' ", e);
            }
            catch (IllegalArgumentException e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem with the content of the properties file '" + propFileName + "' ", e);
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fFullPropertyFileName == null) {
            try {
                String javaHome = System.getProperty("java.home");
                fFullPropertyFileName = javaHome + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fFullPropertyFileName;
    }

    public abstract WSDLReader newWSDLReader() throws WSDLException;

    public abstract DescriptionElement newDescription();

    public abstract ExtensionRegistry newPopulatedExtensionRegistry() throws WSDLException;
}

