/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class OfflineMessageRequest
extends IQ {
    private List items = new ArrayList();
    private boolean purge = false;
    private boolean fetch = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getItems() {
        List list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.items)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<offline xmlns=\"http://jabber.org/protocol/offline\">");
        List list = this.items;
        synchronized (list) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                buf.append(item.toXML());
            }
        }
        if (this.purge) {
            buf.append("<purge/>");
        }
        if (this.fetch) {
            buf.append("<fetch/>");
        }
        buf.append(this.getExtensionsXML());
        buf.append("</offline>");
        return buf.toString();
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            OfflineMessageRequest request = new OfflineMessageRequest();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("item")) {
                        request.addItem(this.parseItem(parser));
                        continue;
                    }
                    if (parser.getName().equals("purge")) {
                        request.setPurge(true);
                        continue;
                    }
                    if (!parser.getName().equals("fetch")) continue;
                    request.setFetch(true);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("offline")) continue;
                done = true;
            }
            return request;
        }

        private Item parseItem(XmlPullParser parser) throws Exception {
            boolean done = false;
            Item item = new Item(parser.getAttributeValue("", "node"));
            item.setAction(parser.getAttributeValue("", "action"));
            item.setJid(parser.getAttributeValue("", "jid"));
            while (!done) {
                int eventType = parser.next();
                if (eventType != 3 || !parser.getName().equals("item")) continue;
                done = true;
            }
            return item;
        }
    }

    public static class Item {
        private String action;
        private String jid;
        private String node;

        public Item(String node) {
            this.node = node;
        }

        public String getNode() {
            return this.node;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<item");
            if (this.getAction() != null) {
                buf.append(" action=\"").append(this.getAction()).append("\"");
            }
            if (this.getJid() != null) {
                buf.append(" jid=\"").append(this.getJid()).append("\"");
            }
            if (this.getNode() != null) {
                buf.append(" node=\"").append(this.getNode()).append("\"");
            }
            buf.append("/>");
            return buf.toString();
        }
    }
}

