/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.axis2.i18n.MessageBundle;
import org.apache.axis2.i18n.MessagesConstants;

public class Messages {
    private static final Class thisClass = Messages.class;
    private static final String projectName = MessagesConstants.projectName;
    private static final String resourceName = MessagesConstants.resourceName;
    private static final Locale locale = MessagesConstants.locale;
    public static final String DEFAULT_MESSAGE_BUNDLE_KEY = "default";
    private static final String NO_MESSAGE_BUNDLE = "Message Bundle is not available";
    private static final String packageName = Messages.getPackage(thisClass.getName());
    private static final ClassLoader classLoader = thisClass.getClassLoader();
    private static final ResourceBundle parent = MessagesConstants.rootPackageName.equals(packageName) ? null : MessagesConstants.rootBundle;
    private static HashMap messageBundleMap = new HashMap();

    public static void addMessageBundle(String messageBundleKey, MessageBundle messageBundle) {
        messageBundleMap.put(messageBundleKey, messageBundle);
    }

    public static String getMessage(String key) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key);
    }

    public static String getMessage(String key, String arg0) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, arg0);
    }

    public static String getMessage(String key, String arg0, String arg1) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, arg0, arg1);
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, arg0, arg1, arg2);
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2, String arg3) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, arg0, arg1, arg2, arg3);
    }

    public static String getMessage(String key, String arg0, String arg1, String arg2, String arg3, String arg4) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, arg0, arg1, arg2, arg3, arg4);
    }

    public static String getMessage(String key, String[] args) throws MissingResourceException {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getMessage(key, args);
    }

    public static ResourceBundle getResourceBundle() {
        MessageBundle messageBundle = Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
        return messageBundle.getResourceBundle();
    }

    public static MessageBundle getMessageBundle() {
        return Messages.getMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY);
    }

    public static MessageBundle getMessageBundle(String messageBundleKey) {
        return (MessageBundle)messageBundleMap.get(messageBundleKey);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key, String arg0) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key, arg0);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key, String arg0, String arg1) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key, arg0, arg1);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key, String arg0, String arg1, String arg2) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key, arg0, arg1, arg2);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key, String arg0, String arg1, String arg2, String arg3) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key, arg0, arg1, arg2, arg3);
    }

    public static String getMessageFromBundle(String messageBundleKey, String key, String arg0, String arg1, String arg2, String arg3, String arg4) throws MissingResourceException, Exception {
        MessageBundle messageBundle = Messages.getMessageBundle(messageBundleKey);
        if (messageBundle == null) {
            throw new Exception(NO_MESSAGE_BUNDLE);
        }
        return messageBundle.getMessage(key, arg0, arg1, arg2, arg3, arg4);
    }

    private static String getPackage(String name) {
        return name.substring(0, name.lastIndexOf(46)).intern();
    }

    static {
        MessageBundle defaultMessageBundle = new MessageBundle(projectName, packageName, resourceName, locale, classLoader, parent);
        Messages.addMessageBundle(DEFAULT_MESSAGE_BUNDLE_KEY, defaultMessageBundle);
    }
}

