/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.HashMap;
import org.jibx.binding.model.ValidationContext;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;

public class ClassUtils {
    private static HashMap s_variantMap = new HashMap();
    private static HashMap s_signatureMap = new HashMap();

    public static boolean isPrimitive(String type) {
        return s_variantMap.get(type) != null;
    }

    public static IClassItem findVirtualMethod(String name, String[] sigs, ValidationContext vctx) {
        int split = name.lastIndexOf(46);
        String cname = name.substring(0, split);
        String mname = name.substring(split + 1);
        IClass iclas = vctx.getClassInfo(cname);
        if (iclas != null) {
            for (int i = 0; i < sigs.length; ++i) {
                IClassItem method = iclas.getMethod(mname, sigs[i]);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static IClassItem findStaticMethod(String name, String[] sigs, ValidationContext vctx) {
        int split = name.lastIndexOf(46);
        if (split > 0) {
            String cname = name.substring(0, split);
            String mname = name.substring(split + 1);
            IClass iclas = vctx.getClassInfo(cname);
            if (iclas != null) {
                for (int i = 0; i < sigs.length; ++i) {
                    IClassItem method = iclas.getStaticMethod(mname, sigs[i]);
                    if (method == null) continue;
                    return method;
                }
            }
        }
        return null;
    }

    public static String[] getSignatureVariants(String name, ValidationContext vctx) {
        Object obj = s_variantMap.get(name);
        if (obj == null) {
            IClass iclas = vctx.getRequiredClassInfo(name);
            return iclas.getInstanceSigs();
        }
        return (String[])obj;
    }

    public static String getSignature(String type) {
        String sig = (String)s_signatureMap.get(type);
        if (sig == null) {
            int dim = 0;
            int split = type.indexOf(91);
            if (split >= 0) {
                int mark = split;
                while (type.length() - mark >= 2) {
                    if (type.charAt(mark) == '[' || type.charAt(mark + 1) == ']') {
                        ++dim;
                        mark += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid type name " + type);
                }
                if (mark < type.length()) {
                    throw new IllegalArgumentException("Invalid type name " + type);
                }
                String cname = type.substring(0, split);
                String base = (String)s_signatureMap.get(cname);
                if (base == null) {
                    base = "L" + cname.replace('.', '/') + ';';
                    s_signatureMap.put(cname, base);
                }
                StringBuffer buff = new StringBuffer(dim + base.length());
                for (int i = 0; i < dim; ++i) {
                    buff.append('[');
                }
                buff.append(base);
                sig = buff.toString();
            } else {
                sig = "L" + type.replace('.', '/') + ';';
            }
            s_signatureMap.put(type, sig);
        }
        return sig;
    }

    public static boolean isAssignable(String from, String to, ValidationContext vctx) {
        if (from.equals(to)) {
            return true;
        }
        Object fobj = s_variantMap.get(from);
        Object tobj = s_variantMap.get(to);
        if (fobj == null && tobj == null) {
            IClass fclas = vctx.getRequiredClassInfo(from);
            IClass tclas = vctx.getRequiredClassInfo(to);
            String[] sigs = fclas.getInstanceSigs();
            String match = tclas.getSignature();
            for (int i = 0; i < sigs.length; ++i) {
                if (!match.equals(sigs[i])) continue;
                return true;
            }
            return false;
        }
        if (fobj != null && tobj != null) {
            String[] fsigs = (String[])fobj;
            String[] tsigs = (String[])tobj;
            if (tsigs.length == 1) {
                for (int i = 0; i < fsigs.length; ++i) {
                    if (fsigs[i] != tsigs[0]) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static {
        s_variantMap.put("boolean", new String[]{"Z"});
        s_variantMap.put("byte", new String[]{"B", "S", "I"});
        s_variantMap.put("char", new String[]{"C", "I"});
        s_variantMap.put("double", new String[]{"D"});
        s_variantMap.put("float", new String[]{"F"});
        s_variantMap.put("int", new String[]{"I"});
        s_variantMap.put("long", new String[]{"J"});
        s_variantMap.put("short", new String[]{"S", "I"});
        s_variantMap.put("void", new String[]{"V"});
        s_signatureMap.put("boolean", "Z");
        s_signatureMap.put("byte", "B");
        s_signatureMap.put("char", "C");
        s_signatureMap.put("double", "D");
        s_signatureMap.put("float", "F");
        s_signatureMap.put("int", "I");
        s_signatureMap.put("long", "J");
        s_signatureMap.put("short", "S");
        s_signatureMap.put("void", "V");
    }
}

