/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ParametersPrinter
extends AbstractPrinter {
    static final int OFFSET_NONE = -1;
    private static final int FIRST_PARAM = 0;
    private static final Printer INSTANCE = new ParametersPrinter();
    private static final int MODE_ALWAYS = 1;
    private static final int MODE_AS_NEEDED = 2;

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        int line = out.line;
        boolean wrapped = false;
        Marker marker = out.state.markers.add();
        switch (node.getType()) {
            case 25: {
                boolean align;
                boolean newlineAfter = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, false);
                if (out.mode == 1 && (align = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_PARAMS_METHOD_DEF, false))) {
                    if (newlineAfter) {
                        this.setAlignOffset(node, out);
                    } else {
                        AST expr = node.getFirstChild();
                        if (expr != null) {
                            TestNodeWriter tester = out.testers.get();
                            PrinterFactory.create(expr, out).print(expr, tester);
                            int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                            if (out.column + tester.length > lineLength) {
                                this.setAlignOffset(node, out);
                            }
                            out.testers.release(tester);
                        }
                    }
                }
                wrapped = out.state.parametersWrapped = this.printImpl(node, newlineAfter ? 1 : 2, 25, out);
                out.state.paramOffset = -1;
                break;
            }
            case 39: {
                wrapped = this.printImpl(node, 2, 39, out);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected node type -- " + node);
            }
        }
        if (out.line > line) {
            wrapped = true;
        }
        if (wrapped && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
            }
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                this.printIndentation(-1, out);
            } else {
                this.printIndentation(out);
            }
        }
        out.state.markers.remove(marker, out);
    }

    private void adjustAlignmentOffset(int column, NodeWriter out) {
        if (out.state.paramOffset != -1) {
            out.state.paramOffset = out.state.paramOffset - column + out.column;
        }
    }

    private boolean containsMethodCall(AST node) {
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 85: {
                    break;
                }
                default: {
                    switch (child.getFirstChild().getType()) {
                        case 32: 
                        case 168: {
                            return true;
                        }
                    }
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private AST getFirstStringConcat(AST node) {
        AST expr = node.getFirstChild();
        switch (expr.getType()) {
            case 157: {
                AST first = null;
                AST next = expr.getFirstChild();
                block9: while (next != null) {
                    switch (next.getType()) {
                        case 157: {
                            break;
                        }
                        default: {
                            first = next;
                            break block9;
                        }
                    }
                    next = next.getFirstChild();
                }
                switch (first.getType()) {
                    case 171: {
                        return first;
                    }
                }
            }
        }
        return null;
    }

    private boolean isSingleLiteral(AST node) {
        if (node.getNextSibling() == null && node.getType() != 157) {
            switch (node.getFirstChild().getType()) {
                case 171: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean printImpl(AST node, int action, int type, NodeWriter out) throws IOException {
        JavaNode parameter = (JavaNode)node.getFirstChild();
        if (parameter == null) {
            return false;
        }
        boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        int deepIndentSize = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_DEEP, 55);
        boolean alignMethodCall = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL, false);
        boolean alignMethodCallIfNested = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL_IF_NESTED, false);
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        boolean preferWrapAfterLeftParen = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false);
        boolean wrapIfFirst = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean result = false;
        int paramIndex = 0;
        boolean restoreAction = false;
        int userAction = action;
        boolean firstWrapped = false;
        boolean[] data = this.shouldHaveSmallIndent(parameter, action, type, out, lineLength, alignMethodCall);
        boolean smallIndent = data[0];
        alignMethodCall = data[1];
        if (out.mode == 1) {
            out.state.paramList = true;
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        while (parameter != null) {
            JavaNode next = (JavaNode)parameter.getNextSibling();
            switch (parameter.getType()) {
                case 85: {
                    if (parameter.hasCommentsAfter()) {
                        out.print(",", 85);
                        this.printCommentsAfter(parameter, false, action != 1, out);
                        break;
                    }
                    out.print(",", 85);
                    break;
                }
                default: {
                    if (paramIndex == 0 && alignMethodCall && smallIndent) {
                        out.printNewline();
                        Marker lastMarker = out.state.markers.getLast();
                        Marker current = out.state.markers.add(out.line, 0, true, out);
                    }
                    if (type == 39 && (alignMethodCall || alignMethodCallIfNested && this.containsMethodCall(node))) {
                        if (restoreAction) {
                            action = userAction;
                        }
                        block3 : switch (parameter.getFirstChild().getType()) {
                            case 32: {
                                userAction = action;
                                action = 1;
                                restoreAction = true;
                                break;
                            }
                            default: {
                                switch (out.state.markers.count) {
                                    case 0: 
                                    case 1: {
                                        break block3;
                                    }
                                }
                                action = 1;
                            }
                        }
                    }
                    switch (action) {
                        case 2: {
                            TestNodeWriter tester;
                            if (out.newline) {
                                this.printIndentation(out);
                                if (!preferWrapAfterLeftParen || paramIndex != 0 || out.mode == 2) break;
                                tester = out.testers.get();
                                PrinterFactory.create(node, out).print(node, tester);
                                if (out.column + tester.length + 1 > lineLength) {
                                    firstWrapped = true;
                                }
                                out.testers.release(tester);
                                break;
                            }
                            if (wrapLines && out.mode != 2) {
                                tester = out.testers.get();
                                if (preferWrapAfterLeftParen && paramIndex == 0) {
                                    PrinterFactory.create(node, out).print(node, tester);
                                    ++tester.length;
                                } else {
                                    PrinterFactory.create(parameter, out).print(parameter, tester);
                                }
                                if (!preferWrapAfterLeftParen && next != null) {
                                    tester.length = spaceAfterComma ? (tester.length += 2) : ++tester.length;
                                }
                                if (out.column + tester.length > lineLength) {
                                    if (paramIndex == 0) {
                                        if (preferWrapAfterLeftParen) {
                                            firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                        } else if (!indentDeep && !this.shouldWrapAtLowerLevel(parameter.getFirstChild(), lineLength, deepIndentSize, out)) {
                                            if (type == 25) {
                                                firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                            } else if (!JavaNodeHelper.isChained(((JavaNode)node).getPreviousSibling())) {
                                                if (this.isSingleLiteral(parameter)) {
                                                    firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                                } else {
                                                    AST first = this.getFirstStringConcat(parameter);
                                                    if (first != null) {
                                                        tester.reset();
                                                        PrinterFactory.create(first, out).print(first, tester);
                                                        firstWrapped = out.column + tester.length > lineLength ? (result = this.wrapFirst(type, true, next == null, out)) : (result = this.wrapFirst(type, next == null, out));
                                                    } else {
                                                        firstWrapped = parameter.getFirstChild().getType() == 171 ? (result = this.wrapFirst(type, next == null, true, out)) : (result = this.wrapFirst(type, next == null, out));
                                                    }
                                                }
                                            }
                                        }
                                    } else {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        result = true;
                                    }
                                } else if (wrapIfFirst && firstWrapped) {
                                    int length;
                                    int indentLength = out.getIndentLength();
                                    Marker m = out.state.markers.getLast();
                                    int n = length = m.column > indentLength ? m.column - indentLength : m.column;
                                    if (length + indentLength + 1 != out.column) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        result = true;
                                    } else if (spaceAfterComma) {
                                        out.print(" ", 175);
                                    }
                                } else if (spaceAfterComma && paramIndex != 0) {
                                    out.print(" ", 175);
                                }
                                out.testers.release(tester);
                                break;
                            }
                            if (!spaceAfterComma || paramIndex == 0) break;
                            out.print(" ", 175);
                            break;
                        }
                        case 1: {
                            TestNodeWriter tester;
                            if (paramIndex != 0) {
                                if (!out.newline) {
                                    out.printNewline();
                                    result = true;
                                }
                                this.printIndentation(out);
                                break;
                            }
                            if (out.newline) {
                                this.printIndentation(out);
                                firstWrapped = true;
                                break;
                            }
                            if (preferWrapAfterLeftParen || !indentDeep) {
                                if (next == null) {
                                    tester = out.testers.get();
                                    PrinterFactory.create(parameter, out).print(parameter, tester);
                                    if (out.column + tester.length + 1 > lineLength) {
                                        result = this.wrapFirst(type, true, next == null, out);
                                        firstWrapped = true;
                                    }
                                    out.testers.release(tester);
                                    break;
                                }
                                firstWrapped = result = this.wrapFirst(type, preferWrapAfterLeftParen || !indentDeep, next == null, out);
                                break;
                            }
                            if (out.column <= deepIndentSize) break;
                            firstWrapped = result = this.wrapFirst(type, preferWrapAfterLeftParen, next == null, out);
                        }
                    }
                    PrinterFactory.create(parameter, out).print(parameter, out);
                    ++paramIndex;
                }
            }
            parameter = next;
        }
        if (out.mode == 1) {
            out.state.paramList = false;
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        return result;
    }

    private void setAlignOffset(AST node, NodeWriter out) throws IOException {
        int result = 0;
        TestNodeWriter tester = out.testers.get();
        AST modifier = null;
        AST type = null;
        AST param = node.getFirstChild();
        while (param != null) {
            switch (param.getType()) {
                case 85: {
                    break;
                }
                case 49: {
                    modifier = param.getFirstChild();
                    PrinterFactory.create(modifier, out).print(modifier, tester);
                    type = modifier.getNextSibling();
                    PrinterFactory.create(type, out).print(type, tester);
                    if (tester.length + 4 > result) {
                        result = tester.length + 4;
                    }
                    tester.reset();
                    break;
                }
                default: {
                    modifier = param.getFirstChild();
                    PrinterFactory.create(modifier, out).print(modifier, tester);
                    type = modifier.getNextSibling();
                    PrinterFactory.create(type, out).print(type, tester);
                    int length = tester.length + 1;
                    if (length > result) {
                        result = length;
                    }
                    tester.reset();
                }
            }
            param = param.getNextSibling();
        }
        out.testers.release(tester);
        out.state.paramOffset = out.column + result;
    }

    private boolean[] shouldHaveSmallIndent(JavaNode parameter, int action, int type, NodeWriter out, int lineLength, boolean alignMethodCall) throws IOException {
        boolean[] results = new boolean[]{false, alignMethodCall};
        int totalParameterWidth = 0;
        int totalParameters = 0;
        boolean smallindent = false;
        boolean debugmode = false;
        JavaNode littleParam = null;
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_HARD, false)) {
            if (debugmode) {
                System.out.println("**Scanning line " + out.line + "," + out.column + "," + totalParameterWidth + "," + type + "," + out.getClass());
                if (out.line == 148) {
                    System.out.println("ASS");
                }
            }
            if (type != 25) {
                TestNodeWriter paramTester = out.testers.get();
                paramTester.reset(out, false);
                littleParam = parameter;
                while (littleParam != null) {
                    PrinterFactory.create(littleParam, out).print(littleParam, paramTester);
                    if (85 != littleParam.getType()) {
                        ++totalParameters;
                    }
                    littleParam = (JavaNode)littleParam.getNextSibling();
                    if (!paramTester.state.smallIndent) continue;
                    smallindent = true;
                }
                totalParameterWidth = paramTester.maxColumn + 1;
                if (debugmode) {
                    System.out.println("initial result " + paramTester.line + "," + paramTester.column + "," + paramTester.maxColumn + "," + smallindent);
                }
                if (smallindent || totalParameterWidth > lineLength || paramTester.line > 1) {
                    boolean pt1;
                    TestNodeWriter paramTester2 = out.testers.get();
                    paramTester2.reset(out, false);
                    if (debugmode) {
                        System.out.println("***Choosing to perform second scan on line" + out.line + "," + out.column);
                    }
                    littleParam = parameter;
                    while (littleParam != null) {
                        PrinterFactory.create(littleParam, out).print(littleParam, paramTester2);
                        littleParam = (JavaNode)littleParam.getNextSibling();
                        if (littleParam == null || (littleParam = (JavaNode)littleParam.getNextSibling()) == null) continue;
                        paramTester2.printNewline();
                        this.printIndentation(paramTester2);
                    }
                    boolean bl = pt1 = paramTester.maxColumn > lineLength + 3;
                    if (debugmode) {
                        System.out.println(pt1 + "Paramtesters 1," + paramTester.line + "," + paramTester.column + "," + paramTester.maxColumn + ":" + paramTester.state.smallIndent);
                    }
                    if (debugmode) {
                        System.out.println("Paramtesters 2," + paramTester2.line + "," + paramTester2.column + "," + paramTester2.maxColumn + ":" + paramTester2.state.smallIndent);
                    }
                    if (paramTester.line >= paramTester2.line || pt1 || !paramTester2.state.smallIndent && paramTester.state.smallIndent) {
                        if (debugmode) {
                            System.out.println("Opting with 2");
                        }
                        out.testers.release(paramTester);
                        paramTester = paramTester2;
                        alignMethodCall = true;
                    } else {
                        if (debugmode) {
                            System.out.println("Opting with 1");
                        }
                        out.testers.release(paramTester2);
                    }
                    boolean bl2 = smallindent = paramTester.state.smallIndent || AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_DEEP, false);
                    if (!smallindent) {
                        boolean bl3 = smallindent = paramTester.maxColumn > lineLength + 3;
                    }
                    if (smallindent && !alignMethodCall) {
                        alignMethodCall = true;
                    }
                }
                totalParameterWidth = paramTester.maxColumn + 1;
                if (debugmode) {
                    System.out.println("Param tester status" + paramTester.line + "," + paramTester.column);
                }
                out.testers.release(paramTester);
            }
            if (debugmode) {
                System.out.println("FLAGS " + smallindent + "," + alignMethodCall);
                System.out.println("**Scanned line " + out.line + "," + out.column + "," + totalParameterWidth);
            }
            if (out instanceof TestNodeWriter && !out.state.smallIndent) {
                out.state.smallIndent = smallindent;
            }
            results[0] = smallindent;
            results[1] = alignMethodCall;
        }
        return results;
    }

    private boolean shouldWrapAtLowerLevel(AST node, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        AST child = node;
        while (child != null) {
            switch (child.getType()) {
                case 39: 
                case 81: 
                case 157: {
                    AST first = child;
                    AST next = node.getFirstChild();
                    block18: while (next != null) {
                        switch (next.getType()) {
                            case 157: {
                                break;
                            }
                            default: {
                                first = next;
                                break block18;
                            }
                        }
                        next = next.getFirstChild();
                    }
                    switch (first.getType()) {
                        case 171: {
                            TestNodeWriter tester = out.testers.get();
                            PrinterFactory.create(first, out).print(first, tester);
                            if (out.column + tester.length > lineLength) {
                                out.testers.release(tester);
                                return false;
                            }
                            out.testers.release(tester);
                        }
                    }
                    return true;
                }
                case 32: {
                    AST name = child.getFirstChild();
                    if (out.column < deepIndent && JavaNodeHelper.isChained(name)) {
                        return true;
                    }
                    String text = JavaNodeHelper.getDottedName(name);
                    if (out.column + text.length() > lineLength) {
                        return false;
                    }
                    AST elist = name.getNextSibling();
                    int paramNum = 0;
                    AST param = elist.getFirstChild();
                    while (param != null) {
                        ++paramNum;
                        param = param.getNextSibling();
                    }
                    return paramNum > 0;
                }
                case 168: {
                    AST name = child.getFirstChild();
                    if (out.column + 4 + name.getText().length() > lineLength) {
                        return false;
                    }
                    AST c = child.getFirstChild();
                    while (c != null) {
                        switch (c.getType()) {
                            case 34: {
                                return false;
                            }
                            case 11: {
                                return true;
                            }
                        }
                        c = c.getNextSibling();
                    }
                    AST elist = name.getNextSibling();
                    boolean paramNum = false;
                    AST param = elist.getFirstChild();
                    while (param != null) {
                        if (paramNum) {
                            return true;
                        }
                        param = param.getNextSibling();
                    }
                    return false;
                }
                case 114: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 158: 
                case 163: {
                    return true;
                }
                case 108: {
                    return this.shouldWrapAtLowerLevel(PrinterHelper.advanceToFirstNonParen(child), deepIndent, lineLength, out);
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean wrapFirst(int type, boolean last, NodeWriter out) throws IOException {
        return this.wrapFirst(type, false, last, out);
    }

    private boolean wrapFirst(int type, boolean force, boolean last, NodeWriter out) throws IOException {
        boolean result = false;
        if (!AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false) || !last) {
            switch (out.state.paramLevel) {
                case 0: {
                    if (!out.state.markers.isMarked()) {
                        throw new IllegalStateException("not inside parentheses and no marker found");
                    }
                }
                case 1: {
                    int length = out.indentSize;
                    if (force || length + out.getIndentLength() < out.column && length > out.column - out.indentSize) {
                        int column = out.column;
                        out.printNewline();
                        this.printIndentation(out);
                        result = true;
                        this.adjustAlignmentOffset(column, out);
                    }
                    out.state.markers.add();
                    break;
                }
                default: {
                    Marker marker = out.state.markers.get(out.state.markers.count - 2);
                    int indentLength = out.getIndentLength();
                    int offset = (marker.column > indentLength ? marker.column - indentLength : marker.column) + out.indentSize;
                    if (offset + indentLength < out.column && (offset + indentLength < out.column - out.indentSize || offset + indentLength > out.column + out.indentSize)) {
                        int column = out.column;
                        out.printNewline();
                        this.printIndentation(out);
                        result = true;
                        this.adjustAlignmentOffset(column, out);
                    }
                    out.state.markers.add();
                    break;
                }
            }
        }
        return result;
    }
}

