/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class PrecompiledConcreteMapping
implements IMapping {
    private final ClassFile m_class;
    private final String m_mappingName;
    private final NameDefinition m_name;
    private final IContainer m_container;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;

    public PrecompiledConcreteMapping(String mapname, String type, NameDefinition name, String marname, String umarname, IContainer parent) throws JiBXException {
        this.m_class = ClassCache.getClassFile(type);
        this.m_mappingName = mapname;
        parent.getBindingRoot().addMappingName(mapname);
        this.m_name = name;
        this.m_container = parent;
        this.m_marshaller = marname == null ? null : ClassCache.getClassFile(marname);
        this.m_unmarshaller = umarname == null ? null : ClassCache.getClassFile(umarname);
    }

    public void linkMappings() throws JiBXException {
    }

    public String getBoundType() {
        return this.m_class.getName();
    }

    public String getReferenceType() {
        return this.m_class.getName();
    }

    public IComponent getImplComponent() {
        return null;
    }

    public ClassFile getMarshaller() {
        return this.m_marshaller;
    }

    public ClassFile getUnmarshaller() {
        return this.m_unmarshaller;
    }

    public NameDefinition getName() {
        return this.m_name;
    }

    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        throw new IllegalArgumentException("Internal error - namespace cannot be added to precompiled mapping");
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isBase() {
        return false;
    }

    public void addExtension(MappingDefinition mdef) throws JiBXException {
        throw new IllegalArgumentException("Internal error - extension cannot be added to precompiled mapping");
    }

    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        DirectObject dobj = new DirectObject(this.m_container, null, this.m_class, false, this.m_marshaller, this.m_unmarshaller, this.m_mappingName, null);
        return new DirectProperty(prop, dobj);
    }

    public ArrayList getNamespaces() {
        return null;
    }

    public void generateCode(boolean force) throws JiBXException {
    }

    public NameDefinition getWrapperName() {
        return this.m_name;
    }

    public ITypeBinding getBinding() {
        return null;
    }

    public String getMappingName() {
        return this.m_mappingName;
    }

    public String getTypeName() {
        return null;
    }

    public void setLinkages() throws JiBXException {
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("precompiled mapping class " + this.m_class.getName());
        System.out.println(" ('" + this.getMappingName() + "')");
    }
}

