/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavaNodeFactory;
import java.util.ArrayList;
import java.util.List;

final class LoggerTransformation
extends TreeWalker
implements Transformation {
    private static final String DEBUG = "debug";
    private static final String LEVEL_DEBUG = "Level.DEBUG";
    private static final String LOCALIZED_LOG = "l7dlog";
    private static final String PRIORITY_DEBUG = "Priority.DEBUG";
    private List _calls = new ArrayList(50);
    private JavaNodeFactory _factory;

    public LoggerTransformation(JavaNodeFactory factory) {
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AST tree) throws TransformationException {
        try {
            this.walk(tree);
            int i = 0;
            int size = this._calls.size();
            while (i < size) {
                AST node = (AST)this._calls.get(i);
                AST name = node.getFirstChild();
                switch (name.getType()) {
                    case 80: {
                        JavaNode expr;
                        AST firstPart = name.getFirstChild();
                        AST lastPart = firstPart.getNextSibling();
                        String methodName = lastPart.getText();
                        if (!this.isDebugCall(node, methodName) || this.isEnclosed(expr = ((JavaNode)node).getParent())) break;
                        this.addConditional(expr, firstPart);
                    }
                }
                ++i;
            }
            Object var11_10 = null;
            this._calls.clear();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this._calls.clear();
            throw throwable;
        }
    }

    public void visit(AST node) {
        switch (node.getType()) {
            case 32: {
                this._calls.add(node);
            }
        }
    }

    private boolean isDebugCall(AST node, String name) {
        AST params;
        AST expr;
        if (DEBUG.equals(name)) {
            JavaNode n = (JavaNode)node;
            switch (n.getType()) {
                case 33: 
                case 110: {
                    return false;
                }
            }
            AST params2 = JavaNodeHelper.getFirstChild(node, 39);
            AST expr2 = params2.getFirstChild();
            return expr2 != null;
        }
        if (LOCALIZED_LOG.equals(name) && (expr = (params = JavaNodeHelper.getFirstChild(node, 39)).getFirstChild()) != null) {
            AST param = expr.getFirstChild();
            switch (param.getType()) {
                case 80: {
                    String n = JavaNodeHelper.getDottedName(param);
                    if (!LEVEL_DEBUG.equals(n) && !PRIORITY_DEBUG.equals(n)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEnclosed(JavaNode expr) {
        JavaNode parent = expr.getParent();
        switch (parent.getType()) {
            case 121: {
                return true;
            }
            case 12: {
                return this.isEnclosed(parent);
            }
        }
        return false;
    }

    private void addConditional(JavaNode expr, AST name) {
        JavaNode cond = this.createConditional(name);
        JavaNode parent = expr.getParent();
        JavaNode prev = expr.getPreviousSibling();
        JavaNode next = (JavaNode)expr.getNextSibling();
        cond.setParent(parent);
        cond.setPreviousSibling(prev);
        if (parent == prev) {
            prev.setFirstChild(cond);
        } else {
            prev.setNextSibling(cond);
        }
        JavaNode lparen = (JavaNode)cond.getFirstChild().getNextSibling().getNextSibling();
        lparen.setNextSibling(expr);
        expr.setParent(cond);
        expr.setPreviousSibling(lparen);
        expr.setNextSibling(null);
        if (next != null) {
            cond.setNextSibling(next);
            next.setPreviousSibling(cond);
        }
    }

    private JavaNode createConditional(AST name) {
        AST qualifiedName = this._factory.create(80);
        qualifiedName.addChild(this._factory.dupTree(name));
        AST methodName = this._factory.create(79, "isDebugEnabled");
        qualifiedName.addChild(methodName);
        AST methodCall = this._factory.create(32);
        methodCall.addChild(qualifiedName);
        methodCall.addChild(this._factory.create(39));
        methodCall.addChild(this._factory.create(109));
        AST expr = this._factory.create(33);
        expr.addChild(methodCall);
        AST ifNode = this._factory.create(121);
        ifNode.addChild(this._factory.create(108));
        ifNode.addChild(expr);
        ifNode.addChild(this._factory.create(109));
        return (JavaNode)ifNode;
    }
}

