/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.plugin;

import de.hunsicker.jalopy.plugin.SwingAppender;
import de.hunsicker.jalopy.plugin.SwingLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public abstract class AbstractAppender
extends AppenderSkeleton
implements SwingAppender {
    public static final int POS_FILENAME = 1;
    public static final int POS_LINE = 2;
    public static final int POS_TEXT = 4;
    public static final int POS_COLUMN = 3;
    private static final String APPENDER_NAME = "JalopyAppender";
    private static final String PATTERN = "(.+?):(\\d+):(\\d+):\\s*(.+)";
    protected final Pattern regex;

    public AbstractAppender() {
        this.name = APPENDER_NAME;
        this.layout = new SwingLayout();
        this.setThreshold((Priority)Level.DEBUG);
        this.regex = Pattern.compile(PATTERN);
    }

    public abstract void append(LoggingEvent var1);

    public final void setName(String name) {
    }

    public void close() {
    }

    public void done() {
    }

    public Matcher parseMessage(LoggingEvent ev) {
        Matcher matcher = this.regex.matcher(this.layout.format(ev));
        if (matcher.matches()) {
            return matcher;
        }
        return null;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected boolean checkEntryConditions() {
        return true;
    }
}

