/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.axis2.wsdl.util.Constants;

public class XSLTIncludeResolver
implements URIResolver,
Constants {
    private CodeGenConfiguration configuration;
    public static final String EMPTY_TEMPLATE = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"/>";

    public XSLTIncludeResolver() {
    }

    public XSLTIncludeResolver(CodeGenConfiguration config) {
        this.configuration = config;
    }

    public Source resolve(String href, String base) throws TransformerException {
        Map externalPropertyMap = this.configuration.getProperties();
        if ("databindsupporter".equals(href)) {
            Map dbSupporterMap = ConfigPropertyFileLoader.getDbSupporterTemplatesMap();
            for (String key : dbSupporterMap.keySet()) {
                if (key.indexOf(this.configuration.getDatabindingType()) == -1) continue;
                return this.getSourceFromTemplateName((String)dbSupporterMap.get(key));
            }
        }
        if ("testObject".equals(href)) {
            return this.getSourceFromTemplateName(ConfigPropertyFileLoader.getTestObjectTemplateName());
        }
        if (externalPropertyMap.get(href) != null) {
            String templateName = externalPropertyMap.get(href).toString();
            if (templateName != null) {
                InputStream supporterTemplateStream = this.getClass().getResourceAsStream(templateName);
                return new StreamSource(supporterTemplateStream);
            }
        } else if (href != null && !href.equals("externalTemplate")) {
            Source source = this.getSourceFromTemplateName(href);
            if (source != null && ((StreamSource)source).getInputStream() != null) {
                return source;
            }
            return this.getEmptySource();
        }
        return this.getEmptySource();
    }

    private Source getSourceFromTemplateName(String templateName) throws TransformerException {
        if (templateName != null) {
            InputStream supporterTemplateStream = this.getClass().getResourceAsStream(templateName);
            return new StreamSource(supporterTemplateStream);
        }
        throw new TransformerException(CodegenMessages.getMessage("resolver.templateNotFound", templateName));
    }

    private Source getEmptySource() {
        return new StreamSource(new ByteArrayInputStream(EMPTY_TEMPLATE.getBytes()));
    }
}

